#
# Copyright (c) Contributors to the Open 3D Engine Project.
# For complete copyright and license terms please see the LICENSE at the root of this distribution.
# 
# SPDX-License-Identifier: Apache-2.0 OR MIT
#
#

# this file actually ingests the library and defines targets.
if (TARGET 3rdParty::OpenImageIO)
    return()
endif()

# OpenImageIO depends on OpenColorIO.  This package includes it!
find_package(OpenColorIO)

if (NOT TARGET ZLIB::ZLIB)
    if (COMMAND ly_download_associated_package)
        # if we happen to be inside O3DE we can use its package system to grab ZLIB.
        ly_download_associated_package(ZLIB)
    endif()
    find_package(ZLIB)
endif()

# todo: FIX THIS
if (NOT TARGET PNG::PNG)
    if (COMMAND ly_download_associated_package)
        ly_download_associated_package(PNG)
    endif()
    find_package(PNG)
endif()

if (NOT TARGET Imath::Imath)
    if (COMMAND ly_download_associated_package)
        ly_download_associated_package(Imath)
    endif()
    find_package(Imath)
endif()

if (NOT TARGET Freetype::Freetype)
    if (COMMAND ly_download_associated_package)
        ly_download_associated_package(Freetype)
    endif()
    find_package(Freetype)
endif()

if (NOT TARGET OpenEXR::OpenEXR)
    if (COMMAND ly_download_associated_package)
        ly_download_associated_package(OpenEXR)
    endif()
    find_package(OpenEXR)
endif()

if (NOT TARGET TIFF::TIFF)
    if (COMMAND ly_download_associated_package)
        ly_download_associated_package(TIFF)
    endif()
    find_package(TIFF)
endif()

if (NOT TARGET expat::expat)
    if (COMMAND ly_download_associated_package)
        ly_download_associated_package(expat)
    endif()
    find_package(expat)
endif()

# the following block sets the variables that are expected
# if you were to use the built-in CMake FindOpenImageIO.cmake
set(OpenImageIO_INCLUDE_DIR ${CMAKE_CURRENT_LIST_DIR}/OpenImageIO/include)
set(OpenImageIO_LIB_DIR ${CMAKE_CURRENT_LIST_DIR}/OpenImageIO/lib)
set(OpenImageIO_BIN_DIR ${CMAKE_CURRENT_LIST_DIR}/OpenImageIO/bin)
set(OpenImageIO_VERSION "2.3.17.0")
set(OpenImageIO_FOUND True)

# On Windows, the shared libraries are under the bin directory,
# but on Linux/Darwin they are still under the lib directory
if (${CMAKE_SYSTEM_NAME} STREQUAL Windows)
    set(OpenImageIO_SHARED_LIB_DIR ${OpenImageIO_BIN_DIR})
else()
    set(OpenImageIO_SHARED_LIB_DIR ${OpenImageIO_LIB_DIR})
endif()
set(OpenImageIO_Util_SHARED_LIB ${OpenImageIO_SHARED_LIB_DIR}/${CMAKE_SHARED_LIBRARY_PREFIX}OpenImageIO_Util${CMAKE_SHARED_LIBRARY_SUFFIX})
set(OpenImageIO_SHARED_LIB ${OpenImageIO_SHARED_LIB_DIR}/${CMAKE_SHARED_LIBRARY_PREFIX}OpenImageIO${CMAKE_SHARED_LIBRARY_SUFFIX})

# We need to make all the shared libraries available as runtime dependencies
# On Windows, there's only the single shared library (.dll)
# On Linux/Darwin, we need to account for all the versioned shared libraries
if(${CMAKE_SYSTEM_NAME} STREQUAL "Windows")
    set(OpenImageIO_Util_SHARED_LIBS ${OpenImageIO_Util_SHARED_LIB})
    set(OpenImageIO_SHARED_LIBS ${OpenImageIO_SHARED_LIB})
elseif(${CMAKE_SYSTEM_NAME} STREQUAL "Linux")
    set(OpenImageIO_Util_SHARED_LIBS
        ${OpenImageIO_Util_SHARED_LIB}
        ${OpenImageIO_Util_SHARED_LIB}.2.3
        ${OpenImageIO_Util_SHARED_LIB}.2.3.17
    )
    set(OpenImageIO_SHARED_LIBS
        ${OpenImageIO_SHARED_LIB}
        ${OpenImageIO_SHARED_LIB}.2.3
        ${OpenImageIO_SHARED_LIB}.2.3.17
    )
else() # Darwin
    set(OpenImageIO_Util_SHARED_LIBS
        ${OpenImageIO_Util_SHARED_LIB}
        ${OpenImageIO_SHARED_LIB_DIR}/${CMAKE_SHARED_LIBRARY_PREFIX}OpenImageIO_Util.2.3${CMAKE_SHARED_LIBRARY_SUFFIX}
        ${OpenImageIO_SHARED_LIB_DIR}/${CMAKE_SHARED_LIBRARY_PREFIX}OpenImageIO_Util.2.3.17${CMAKE_SHARED_LIBRARY_SUFFIX}
    )
    set(OpenImageIO_SHARED_LIBS
        ${OpenImageIO_SHARED_LIB}
        ${OpenImageIO_SHARED_LIB_DIR}/${CMAKE_SHARED_LIBRARY_PREFIX}OpenImageIO.2.3${CMAKE_SHARED_LIBRARY_SUFFIX}
        ${OpenImageIO_SHARED_LIB_DIR}/${CMAKE_SHARED_LIBRARY_PREFIX}OpenImageIO.2.3.17${CMAKE_SHARED_LIBRARY_SUFFIX}
    )
endif()

add_library(OpenImageIO::OpenImageIO_Util SHARED IMPORTED GLOBAL)
set_target_properties(OpenImageIO::OpenImageIO_Util PROPERTIES 
    IMPORTED_LOCATION ${OpenImageIO_Util_SHARED_LIB})

add_library(OpenImageIO::OpenImageIO SHARED IMPORTED GLOBAL)
set_target_properties(OpenImageIO::OpenImageIO PROPERTIES
    IMPORTED_LOCATION ${OpenImageIO_SHARED_LIB})

# Make sure pthreads gets linked properly (typically on linux)
find_package(Threads)
if (CMAKE_USE_PTHREADS_INIT)
    target_link_libraries(OpenImageIO::OpenImageIO INTERFACE ${CMAKE_THREAD_LIBS_INIT})
endif ()

target_link_libraries(OpenImageIO::OpenImageIO INTERFACE 
    OpenImageIO::OpenImageIO_Util
    OpenColorIO::OpenColorIO
    ${CMAKE_DL_LIBS}
)

if(${CMAKE_SYSTEM_NAME} STREQUAL "Darwin")
target_link_libraries(OpenImageIO::OpenImageIO INTERFACE
    "-framework Carbon"
    "-framework IOKit"
)
endif()

if (COMMAND ly_target_include_system_directories)
    # O3DE has an extension to fix system directory includes until CMake
    # has a proper fix for it, so if its available, use that:
    ly_target_include_system_directories(TARGET OpenImageIO::OpenImageIO INTERFACE ${OpenImageIO_INCLUDE_DIR})
else()
    # extension is not available (or not necessary anymore) 
    # so use default CMake SYSTEM include feature:
    target_include_directories(OpenImageIO::OpenImageIO SYSTEM INTERFACE ${OpenImageIO_INCLUDE_DIR})
endif()

# Find the right python binding per platform
if(${CMAKE_SYSTEM_NAME} STREQUAL "Windows")
    set(OpenImageIOPythonBindings ${OpenImageIO_LIB_DIR}/python3.10/site-packages/OpenImageIO.cp310-win_amd64.pyd)
elseif(${CMAKE_SYSTEM_NAME} STREQUAL "Linux")
    set(OpenImageIOPythonBindings ${OpenImageIO_LIB_DIR}/python3.10/site-packages/OpenImageIO.cpython-310-x86_64-linux-gnu.so)
    
else() # Darwin
    set(OpenImageIOPythonBindings ${OpenImageIO_LIB_DIR}/python3.10/site-packages/OpenImageIO.cpython-310-darwin.so)
endif()

set(OpenImageIO_TOOLS_BINARIES
    ${OpenImageIO_BIN_DIR}/iconvert${CMAKE_EXECUTABLE_SUFFIX}
    ${OpenImageIO_BIN_DIR}/idiff${CMAKE_EXECUTABLE_SUFFIX}
    ${OpenImageIO_BIN_DIR}/igrep${CMAKE_EXECUTABLE_SUFFIX}
    ${OpenImageIO_BIN_DIR}/iinfo${CMAKE_EXECUTABLE_SUFFIX}
    ${OpenImageIO_BIN_DIR}/maketx${CMAKE_EXECUTABLE_SUFFIX}
    ${OpenImageIO_BIN_DIR}/oiiotool${CMAKE_EXECUTABLE_SUFFIX}
)


if (${CMAKE_SYSTEM_NAME} STREQUAL Windows)
    # windows also has the regular import libraries (lib files) associated with its dll.   On linux and mac, the import library
    # is part of the dynamic library, and thus no IMPLIB needs to be specified on those platforms.
    set_target_properties(OpenImageIO::OpenImageIO_Util PROPERTIES 
        IMPORTED_IMPLIB ${OpenImageIO_LIB_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}OpenImageIO_Util${CMAKE_STATIC_LIBRARY_SUFFIX}
    )
    set_target_properties(OpenImageIO::OpenImageIO PROPERTIES
        IMPORTED_IMPLIB ${OpenImageIO_LIB_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}OpenImageIO${CMAKE_STATIC_LIBRARY_SUFFIX}
    )

    # on windows, we also have a debug version of both the library and the import library, so add them:
    set_target_properties(OpenImageIO::OpenImageIO_Util PROPERTIES
        IMPORTED_LOCATION_DEBUG ${OpenImageIO_BIN_DIR}/${CMAKE_SHARED_LIBRARY_PREFIX}OpenImageIO_Util_d${CMAKE_SHARED_LIBRARY_SUFFIX}
        IMPORTED_IMPLIB_DEBUG   ${OpenImageIO_LIB_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}OpenImageIO_Util_d${CMAKE_STATIC_LIBRARY_SUFFIX}
    )
    set_target_properties(OpenImageIO::OpenImageIO PROPERTIES
        IMPORTED_LOCATION_DEBUG ${OpenImageIO_BIN_DIR}/${CMAKE_SHARED_LIBRARY_PREFIX}OpenImageIO_d${CMAKE_SHARED_LIBRARY_SUFFIX}
        IMPORTED_IMPLIB_DEBUG   ${OpenImageIO_LIB_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}OpenImageIO_d${CMAKE_STATIC_LIBRARY_SUFFIX}
    )

    # another issue is that on windows, the executable binary tools as well as python modules ship as release,
    # and thus depend on the release binaries.  These will need to be deployed, too.  So create a target that represents the 
    # shared release libraries, so that the binaries and the python tools can depend on them:
    add_library(OpenImageIO::OpenImageIO::ReleaseSharedLibraries SHARED IMPORTED GLOBAL)
    add_library(OpenImageIO::OpenImageIO_Util::ReleaseSharedLibraries SHARED IMPORTED GLOBAL)

    set_target_properties(OpenImageIO::OpenImageIO::ReleaseSharedLibraries      PROPERTIES IMPORTED_LOCATION ${OpenImageIO_SHARED_LIB})
    set_target_properties(OpenImageIO::OpenImageIO_Util::ReleaseSharedLibraries PROPERTIES IMPORTED_LOCATION ${OpenImageIO_Util_SHARED_LIB})

    # add this to any targets that need the release libraries.  on platforms besides windows, its going to be blank:
    set(_ADDITIONAL_OPENIMAGEIO_RUNTIME_TARGETS OpenImageIO::OpenImageIO::ReleaseSharedLibraries OpenImageIO::OpenImageIO_Util::ReleaseSharedLibraries)
    
endif()

add_library(OpenImageIO::OpenImageIO::Tools::Binaries INTERFACE IMPORTED GLOBAL)
add_library(OpenImageIO::OpenImageIO::Tools::PythonPlugins INTERFACE IMPORTED GLOBAL)
if (COMMAND ly_add_target_files)
    ly_add_target_files(TARGETS OpenImageIO::OpenImageIO::Tools::Binaries FILES ${OpenImageIO_TOOLS_BINARIES})
    ly_add_target_files(TARGETS OpenImageIO::OpenImageIO::Tools::PythonPlugins FILES ${OpenImageIOPythonBindings})
endif()

# Our OpenImageIO tools also depend on the OpenColorIO runtime (shared library)
target_link_libraries(OpenImageIO::OpenImageIO::Tools::Binaries INTERFACE OpenColorIO::OpenColorIO::Runtime ${_ADDITIONAL_OPENIMAGEIO_RUNTIME_TARGETS})
target_link_libraries(OpenImageIO::OpenImageIO::Tools::PythonPlugins INTERFACE OpenColorIO::OpenColorIO::Runtime ${_ADDITIONAL_OPENIMAGEIO_RUNTIME_TARGETS})

# alias the OpenImageIO library to the O3DE 3rdParty library
add_library(3rdParty::OpenImageIO ALIAS OpenImageIO::OpenImageIO)
add_library(3rdParty::OpenImageIO_Util ALIAS OpenImageIO::OpenImageIO_Util)
add_library(3rdParty::OpenImageIO::Tools::Binaries ALIAS OpenImageIO::OpenImageIO::Tools::Binaries)
add_library(3rdParty::OpenImageIO::Tools::PythonPlugins ALIAS OpenImageIO::OpenImageIO::Tools::PythonPlugins)

# if we're NOT in O3DE, it's also useful to show a message indicating that this
# library was successfully picked up, as opposed to the system one.
# A good way to know if you're in O3DE or not is that O3DE sets various cache variables before 
# calling find_package, specifically, LY_VERSION_ENGINE_NAME is always set very early:
if (NOT LY_VERSION_ENGINE_NAME)
    message(STATUS "Using O3DE OpenImageIO ${OpenImageIO_VERSION} from ${CMAKE_CURRENT_LIST_DIR}")
endif()

# OpenImageIO Also includes a number of executables, as well as a python module.
