#
# Copyright (c) Contributors to the Open 3D Engine Project.
# For complete copyright and license terms please see the LICENSE at the root of this distribution.
# 
# SPDX-License-Identifier: Apache-2.0 OR MIT
#
#

set(TARGET_WITH_NAMESPACE "3rdParty::OpenMesh")
if (TARGET ${TARGET_WITH_NAMESPACE})
    return()
endif()

set(OpenMesh_INCLUDE_DIR ${CMAKE_CURRENT_LIST_DIR}/OpenMesh/include)
set(OpenMesh_LIBS_DIR ${CMAKE_CURRENT_LIST_DIR}/OpenMesh/lib)

set(OpenMesh_LIBRARY_DEBUG   ${OpenMesh_LIBS_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}OpenMeshCored${CMAKE_STATIC_LIBRARY_SUFFIX})
set(OpenMesh_LIBRARY_RELEASE ${OpenMesh_LIBS_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}OpenMeshCore${CMAKE_STATIC_LIBRARY_SUFFIX})

add_library(${TARGET_WITH_NAMESPACE} STATIC IMPORTED GLOBAL)

set_target_properties(${TARGET_WITH_NAMESPACE} PROPERTIES IMPORTED_LOCATION "${OpenMesh_LIBRARY_RELEASE}")
set_target_properties(${TARGET_WITH_NAMESPACE} PROPERTIES IMPORTED_LOCATION_DEBUG "${OpenMesh_LIBRARY_DEBUG}")

ly_target_include_system_directories(
    TARGET ${TARGET_WITH_NAMESPACE} INTERFACE ${OpenMesh_INCLUDE_DIR})

set(OpenMesh_FOUND True)
