#
# All or portions of this file Copyright (c) Amazon.com, Inc. or its affiliates or
# its licensors.
#
# For complete copyright and license terms please see the LICENSE at the root of this
# distribution (the "License"). All use of this software is governed by the License,
# or, if provided, by the license below or the license accompanying this file. Do not
# remove or modify any license notices. This file is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#

# this file actually ingests the library and defines targets.

# Googletest
set(GOOGLETEST_INCLUDE_DIR ${CMAKE_CURRENT_LIST_DIR}/googletest/include)
set(GOOGLETEST_LIBS_DIR ${CMAKE_CURRENT_LIST_DIR}/googletest/lib)

set(GOOGLETEST_COMPILE_DEFINITIONS
)

set(GOOGLETEST_LINK_OPTIONS
    $<$<STREQUAL:${PAL_TRAIT_COMPILER_ID},Clang>:-Wl,>/ignore:4099)

# GTest
#################################################################
set(TARGET_WITH_NAMESPACE "3rdParty::googletest::GTest")
if (NOT TARGET ${TARGET_WITH_NAMESPACE})

    set(GOOGLETEST_GTEST_LIBS_DEBUG   ${GOOGLETEST_LIBS_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}gtestd${CMAKE_STATIC_LIBRARY_SUFFIX})
    set(GOOGLETEST_GTEST_LIBS_RELEASE ${GOOGLETEST_LIBS_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}gtest${CMAKE_STATIC_LIBRARY_SUFFIX})
    set(GOOGLETEST_GTEST_LIBRARY
        "$<$<CONFIG:profile>:${GOOGLETEST_GTEST_LIBS_RELEASE}>"
        "$<$<CONFIG:Release>:${GOOGLETEST_GTEST_LIBS_RELEASE}>"
        "$<$<CONFIG:Debug>:${GOOGLETEST_GTEST_LIBS_DEBUG}>")

    add_library(${TARGET_WITH_NAMESPACE} INTERFACE IMPORTED GLOBAL)
    ly_target_include_system_directories(TARGET ${TARGET_WITH_NAMESPACE} INTERFACE ${GOOGLETEST_INCLUDE_DIR})
    target_link_libraries(${TARGET_WITH_NAMESPACE} INTERFACE ${GOOGLETEST_GTEST_LIBRARY})
    target_link_options(${TARGET_WITH_NAMESPACE} INTERFACE ${GOOGLETEST_LINK_OPTIONS})
    target_compile_definitions(${TARGET_WITH_NAMESPACE} INTERFACE ${GOOGLETEST_COMPILE_DEFINITIONS})
    set(GOOGLETEST_GTEST_FOUND True)
endif()

# GTestMain
#################################################################
set(TARGET_WITH_NAMESPACE "3rdParty::googletest::GTestMain")
if (NOT TARGET ${TARGET_WITH_NAMESPACE})

    set(GOOGLETEST_GTESTMAIN_LIBS_DEBUG   ${GOOGLETEST_LIBS_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}gtest_maind${CMAKE_STATIC_LIBRARY_SUFFIX})
    set(GOOGLETEST_GTESTMAIN_LIBS_RELEASE ${GOOGLETEST_LIBS_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}gtest_main${CMAKE_STATIC_LIBRARY_SUFFIX})
    set(GOOGLETEST_GTESTMAIN_LIBRARY
        "$<$<CONFIG:profile>:${GOOGLETEST_GTESTMAIN_LIBS_RELEASE}>"
        "$<$<CONFIG:Release>:${GOOGLETEST_GTESTMAIN_LIBS_RELEASE}>"
        "$<$<CONFIG:Debug>:${GOOGLETEST_GTESTMAIN_LIBS_DEBUG}>")

    add_library(${TARGET_WITH_NAMESPACE} INTERFACE IMPORTED GLOBAL)
    ly_target_include_system_directories(TARGET ${TARGET_WITH_NAMESPACE} INTERFACE ${GOOGLETEST_INCLUDE_DIR})
    target_link_libraries(${TARGET_WITH_NAMESPACE} INTERFACE ${GOOGLETEST_GTESTMAIN_LIBRARY})
    target_link_options(${TARGET_WITH_NAMESPACE} INTERFACE ${GOOGLETEST_LINK_OPTIONS})
    target_compile_definitions(${TARGET_WITH_NAMESPACE} INTERFACE ${GOOGLETEST_COMPILE_DEFINITIONS})
    set(GOOGLETEST_GTESTMAIN_FOUND True)
endif()

# GMock
#################################################################
set(TARGET_WITH_NAMESPACE "3rdParty::googletest::GMock")
if (NOT TARGET ${TARGET_WITH_NAMESPACE})

    set(GOOGLETEST_GMOCK_LIBS_DEBUG   ${GOOGLETEST_LIBS_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}gmockd${CMAKE_STATIC_LIBRARY_SUFFIX})
    set(GOOGLETEST_GMOCK_LIBS_RELEASE ${GOOGLETEST_LIBS_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}gmock${CMAKE_STATIC_LIBRARY_SUFFIX})
    set(GOOGLETEST_GMOCK_LIBRARY
        "$<$<CONFIG:profile>:${GOOGLETEST_GMOCK_LIBS_RELEASE}>"
        "$<$<CONFIG:Release>:${GOOGLETEST_GMOCK_LIBS_RELEASE}>"
        "$<$<CONFIG:Debug>:${GOOGLETEST_GMOCK_LIBS_DEBUG}>")

    add_library(${TARGET_WITH_NAMESPACE} INTERFACE IMPORTED GLOBAL)
    ly_target_include_system_directories(TARGET ${TARGET_WITH_NAMESPACE} INTERFACE ${GOOGLETEST_INCLUDE_DIR})
    target_link_libraries(${TARGET_WITH_NAMESPACE} INTERFACE ${GOOGLETEST_GMOCK_LIBRARY})
    target_link_options(${TARGET_WITH_NAMESPACE} INTERFACE ${GOOGLETEST_LINK_OPTIONS})
    target_compile_definitions(${TARGET_WITH_NAMESPACE} INTERFACE ${GOOGLETEST_COMPILE_DEFINITIONS})
    set(GOOGLETEST_GMOCK_FOUND True)
endif()


# GMockMain
#################################################################
set(TARGET_WITH_NAMESPACE "3rdParty::googletest::GMockMain")
if (NOT TARGET ${TARGET_WITH_NAMESPACE})

    set(GOOGLETEST_GMOCKMAIN_LIBS_DEBUG   ${GOOGLETEST_LIBS_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}gmock_maind${CMAKE_STATIC_LIBRARY_SUFFIX})
    set(GOOGLETEST_GMOCKMAIN_LIBS_RELEASE ${GOOGLETEST_LIBS_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}gmock_main${CMAKE_STATIC_LIBRARY_SUFFIX})
    set(GOOGLETEST_GMOCKMAIN_LIBRARY
        "$<$<CONFIG:profile>:${GOOGLETEST_GMOCKMAIN_LIBS_RELEASE}>"
        "$<$<CONFIG:Release>:${GOOGLETEST_GMOCKMAIN_LIBS_RELEASE}>"
        "$<$<CONFIG:Debug>:${GOOGLETEST_GMOCKMAIN_LIBS_DEBUG}>")

    add_library(${TARGET_WITH_NAMESPACE} INTERFACE IMPORTED GLOBAL)
    ly_target_include_system_directories(TARGET ${TARGET_WITH_NAMESPACE} INTERFACE ${GOOGLETEST_INCLUDE_DIR})
    target_link_libraries(${TARGET_WITH_NAMESPACE} INTERFACE ${GOOGLETEST_GMOCKMAIN_LIBRARY})
    target_link_options(${TARGET_WITH_NAMESPACE} INTERFACE ${GOOGLETEST_LINK_OPTIONS})
    target_compile_definitions(${TARGET_WITH_NAMESPACE} INTERFACE ${GOOGLETEST_COMPILE_DEFINITIONS})
    set(GOOGLETEST_GMOCKMAIN_FOUND True)
endif()
