#
# All or portions of this file Copyright (c) Amazon.com, Inc. or its affiliates or
# its licensors.
#
# For complete copyright and license terms please see the LICENSE at the root of this
# distribution (the "License"). All use of this software is governed by the License,
# or, if provided, by the license below or the license accompanying this file. Do not
# remove or modify any license notices. This file is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#

include(CMakeParseArguments)

set(CRASHPAD_PACKAGE_NAME Crashpad)
set(CRASHPAD_LIBS_DIR ${CMAKE_CURRENT_LIST_DIR}/Crashpad/$<$<CONFIG:debug>:debug/>lib)
set(CRASHPAD_INCLUDE_DIR ${CMAKE_CURRENT_LIST_DIR}/Crashpad/include/crashpad)

# Helper function to define crashpad libraries
function(ly_declare_crashpad_library)

    set(options HANDLER)
    set(oneValueArgs NAME)
    set(multiValueArgs ADDITIONAL_INCLUDE_DIRS LIBS BUILD_DEPENDENCIES)

    cmake_parse_arguments(ly_declare_crashpad_library "${options}" "${oneValueArgs}" "${multiValueArgs}" ${ARGN})

    if (ly_declare_crashpad_library_HANDLER)
        set(TARGET_WITH_NAMESPACE "3rdParty::${CRASHPAD_PACKAGE_NAME}::Handler")
    else()
        set(TARGET_WITH_NAMESPACE "3rdParty::${CRASHPAD_PACKAGE_NAME}")
    endif()

    if (TARGET ${TARGET_WITH_NAMESPACE})
        return()
    endif()

    add_library(${TARGET_WITH_NAMESPACE} INTERFACE IMPORTED GLOBAL)

    if (ly_declare_crashpad_library_ADDITIONAL_INCLUDE_DIRS)
        ly_target_include_system_directories(TARGET ${TARGET_WITH_NAMESPACE}
            INTERFACE
                "${CRASHPAD_INCLUDE_DIR}"
                "${CRASHPAD_INCLUDE_DIR}/mini_chromium"
                ${ly_declare_crashpad_library_ADDITIONAL_INCLUDE_DIRS}
        )
    else()
        ly_target_include_system_directories(TARGET ${TARGET_WITH_NAMESPACE}
            INTERFACE
                "${CRASHPAD_INCLUDE_DIR}"
                "${CRASHPAD_INCLUDE_DIR}/mini_chromium"
        )
    endif()

    if (ly_declare_crashpad_library_BUILD_DEPENDENCIES)
        target_link_libraries(${TARGET_WITH_NAMESPACE}
            INTERFACE
                ${ly_declare_crashpad_library_LIBS}
                ${ly_declare_crashpad_library_BUILD_DEPENDENCIES}
        )
    else()
        target_link_libraries(${TARGET_WITH_NAMESPACE}
            INTERFACE
                ${ly_declare_crashpad_library_LIBS}
        )
    endif()

endfunction()

#### Crashpad ####
ly_declare_crashpad_library(
    LIBS
        "${CRASHPAD_LIBS_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}base${CMAKE_STATIC_LIBRARY_SUFFIX}"
        "${CRASHPAD_LIBS_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}client${CMAKE_STATIC_LIBRARY_SUFFIX}"
        "${CRASHPAD_LIBS_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}util${CMAKE_STATIC_LIBRARY_SUFFIX}"
)

#### Crashpad Handler ####
ly_declare_crashpad_library(
    HANDLER
    ADDITIONAL_INCLUDE_DIRS
        "${CRASHPAD_INCLUDE_DIR}/getopt"
    LIBS
        "${CRASHPAD_LIBS_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}compat${CMAKE_STATIC_LIBRARY_SUFFIX}"
        "${CRASHPAD_LIBS_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}context${CMAKE_STATIC_LIBRARY_SUFFIX}"
        "${CRASHPAD_LIBS_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}format${CMAKE_STATIC_LIBRARY_SUFFIX}"
        "${CRASHPAD_LIBS_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}minidump${CMAKE_STATIC_LIBRARY_SUFFIX}"
        "${CRASHPAD_LIBS_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}getopt${CMAKE_STATIC_LIBRARY_SUFFIX}"
        "${CRASHPAD_LIBS_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}handler${CMAKE_STATIC_LIBRARY_SUFFIX}"
        "${CRASHPAD_LIBS_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}snapshot${CMAKE_STATIC_LIBRARY_SUFFIX}"
        "${CRASHPAD_LIBS_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}tool_support${CMAKE_STATIC_LIBRARY_SUFFIX}"
        "${CRASHPAD_LIBS_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}zlib${CMAKE_STATIC_LIBRARY_SUFFIX}"
    BUILD_DEPENDENCIES
        "3rdParty::${CRASHPAD_PACKAGE_NAME}"
        # Built-in Windows libraries
        winhttp
        version
        powrprof
)  