#ifndef SBL_ONLY_STRUCT
#define SBL_ONLY_STRUCT
#define SBL_VECTOR
struct ColourSingleLookup_CCR
{
  /* 5 lo, 5 hi, 6 lo, 6 hi */
  uint4 sources;
#define	SB_PACK(cl0, cl1, es)	((es << 16) | (cl1 << 8) | (cl0 << 0))
#define	SB_ERRSQR(p)		(((p) >> 16))
#define	SB_CLINE0(p)		(((p) >>  0) & 0xFF)
#define	SB_CLINE1(p)		(((p) >>  8) & 0xFF)
#define	SB_CLINE(p, o)		(((p) >> (o * 8)) & 0xFF)
};

#if	defined(USE_AMP) || defined(USE_COMPUTE)
#if	!defined(USE_COMPUTE)
typedef const ::Concurrency::array_view<const ::ColourSingleLookup_CCR, 2> &ColourSingleLUT;
#else
typedef const                                 ::ColourSingleLookup_CCR      ColourSingleLUT[2][256];
#endif
#endif
#endif

#if	defined(ONLY_ARRAY)
static_hlsl const ColourSingleLookup_CCR lookup_34_56_ccr[2][256] = {
{ /* 3-step line */
	/* 5-bit color */                                          /* 6-bit color */
	{ { SB_PACK( 0, 0, 0*0) , SB_PACK( 0,  0, 0*0) , SB_PACK( 0, 0, 0*0) , SB_PACK( 0,  0, 0*0) } },
	{ { SB_PACK( 0, 0, 1*1) , SB_PACK( 0,  0, 1*1) , SB_PACK( 0, 0, 1*1) , SB_PACK( 0,  1, 1*1) } },
	{ { SB_PACK( 0, 0, 2*2) , SB_PACK( 0,  0, 2*2) , SB_PACK( 0, 0, 2*2) , SB_PACK( 0,  1, 0*0) } },
	{ { SB_PACK( 0, 0, 3*3) , SB_PACK( 0,  1, 1*1) , SB_PACK( 1, 0, 1*1) , SB_PACK( 0,  2, 1*1) } },
	{ { SB_PACK( 0, 0, 4*4) , SB_PACK( 0,  1, 0*0) , SB_PACK( 1, 0, 0*0) , SB_PACK( 0,  2, 0*0) } },
	{ { SB_PACK( 1, 0, 3*3) , SB_PACK( 0,  1, 1*1) , SB_PACK( 1, 0, 1*1) , SB_PACK( 0,  3, 1*1) } },
	{ { SB_PACK( 1, 0, 2*2) , SB_PACK( 0,  1, 2*2) , SB_PACK( 1, 0, 2*2) , SB_PACK( 0,  3, 0*0) } },
	{ { SB_PACK( 1, 0, 1*1) , SB_PACK( 0,  2, 1*1) , SB_PACK( 2, 0, 1*1) , SB_PACK( 0,  4, 1*1) } },
	{ { SB_PACK( 1, 0, 0*0) , SB_PACK( 0,  2, 0*0) , SB_PACK( 2, 0, 0*0) , SB_PACK( 0,  4, 0*0) } },
	{ { SB_PACK( 1, 0, 1*1) , SB_PACK( 0,  2, 1*1) , SB_PACK( 2, 0, 1*1) , SB_PACK( 0,  5, 1*1) } },
	{ { SB_PACK( 1, 0, 2*2) , SB_PACK( 0,  2, 2*2) , SB_PACK( 2, 0, 2*2) , SB_PACK( 0,  5, 0*0) } },
	{ { SB_PACK( 1, 0, 3*3) , SB_PACK( 0,  3, 1*1) , SB_PACK( 3, 0, 1*1) , SB_PACK( 0,  6, 1*1) } },
	{ { SB_PACK( 1, 0, 4*4) , SB_PACK( 0,  3, 0*0) , SB_PACK( 3, 0, 0*0) , SB_PACK( 0,  6, 0*0) } },
	{ { SB_PACK( 2, 0, 3*3) , SB_PACK( 0,  3, 1*1) , SB_PACK( 3, 0, 1*1) , SB_PACK( 0,  7, 1*1) } },
	{ { SB_PACK( 2, 0, 2*2) , SB_PACK( 0,  3, 2*2) , SB_PACK( 3, 0, 2*2) , SB_PACK( 0,  7, 0*0) } },
	{ { SB_PACK( 2, 0, 1*1) , SB_PACK( 0,  4, 1*1) , SB_PACK( 4, 0, 1*1) , SB_PACK( 0,  8, 1*1) } },
	{ { SB_PACK( 2, 0, 0*0) , SB_PACK( 0,  4, 0*0) , SB_PACK( 4, 0, 0*0) , SB_PACK( 0,  8, 0*0) } },
	{ { SB_PACK( 2, 0, 1*1) , SB_PACK( 0,  4, 1*1) , SB_PACK( 4, 0, 1*1) , SB_PACK( 0,  9, 1*1) } },
	{ { SB_PACK( 2, 0, 2*2) , SB_PACK( 0,  4, 2*2) , SB_PACK( 4, 0, 2*2) , SB_PACK( 0,  9, 0*0) } },
	{ { SB_PACK( 2, 0, 3*3) , SB_PACK( 0,  5, 1*1) , SB_PACK( 5, 0, 1*1) , SB_PACK( 0, 10, 1*1) } },
	{ { SB_PACK( 2, 0, 4*4) , SB_PACK( 0,  5, 0*0) , SB_PACK( 5, 0, 0*0) , SB_PACK( 0, 10, 0*0) } },
	{ { SB_PACK( 3, 0, 3*3) , SB_PACK( 0,  5, 1*1) , SB_PACK( 5, 0, 1*1) , SB_PACK( 0, 11, 1*1) } },
	{ { SB_PACK( 3, 0, 2*2) , SB_PACK( 0,  5, 2*2) , SB_PACK( 5, 0, 2*2) , SB_PACK( 0, 11, 0*0) } },
	{ { SB_PACK( 3, 0, 1*1) , SB_PACK( 0,  6, 1*1) , SB_PACK( 6, 0, 1*1) , SB_PACK( 0, 12, 1*1) } },
	{ { SB_PACK( 3, 0, 0*0) , SB_PACK( 0,  6, 0*0) , SB_PACK( 6, 0, 0*0) , SB_PACK( 0, 12, 0*0) } },
	{ { SB_PACK( 3, 0, 1*1) , SB_PACK( 0,  6, 1*1) , SB_PACK( 6, 0, 1*1) , SB_PACK( 0, 13, 1*1) } },
	{ { SB_PACK( 3, 0, 2*2) , SB_PACK( 0,  6, 2*2) , SB_PACK( 6, 0, 2*2) , SB_PACK( 0, 13, 0*0) } },
	{ { SB_PACK( 3, 0, 3*3) , SB_PACK( 0,  7, 1*1) , SB_PACK( 7, 0, 1*1) , SB_PACK( 0, 14, 1*1) } },
	{ { SB_PACK( 3, 0, 4*4) , SB_PACK( 0,  7, 0*0) , SB_PACK( 7, 0, 0*0) , SB_PACK( 0, 14, 0*0) } },
	{ { SB_PACK( 4, 0, 4*4) , SB_PACK( 0,  7, 1*1) , SB_PACK( 7, 0, 1*1) , SB_PACK( 0, 15, 1*1) } },
	{ { SB_PACK( 4, 0, 3*3) , SB_PACK( 0,  7, 2*2) , SB_PACK( 7, 0, 2*2) , SB_PACK( 0, 15, 0*0) } },
	{ { SB_PACK( 4, 0, 2*2) , SB_PACK( 1,  7, 1*1) , SB_PACK( 8, 0, 1*1) , SB_PACK( 0, 16, 1*1) } },
	{ { SB_PACK( 4, 0, 1*1) , SB_PACK( 1,  7, 0*0) , SB_PACK( 8, 0, 0*0) , SB_PACK( 0, 16, 0*0) } },
	{ { SB_PACK( 4, 0, 0*0) , SB_PACK( 0,  8, 0*0) , SB_PACK( 8, 0, 1*1) , SB_PACK( 0, 17, 1*1) } },
	{ { SB_PACK( 4, 0, 1*1) , SB_PACK( 0,  8, 1*1) , SB_PACK( 8, 0, 2*2) , SB_PACK( 0, 17, 0*0) } },
	{ { SB_PACK( 4, 0, 2*2) , SB_PACK( 2,  7, 1*1) , SB_PACK( 9, 0, 1*1) , SB_PACK( 0, 18, 1*1) } },
	{ { SB_PACK( 4, 0, 3*3) , SB_PACK( 2,  7, 0*0) , SB_PACK( 9, 0, 0*0) , SB_PACK( 0, 18, 0*0) } },
	{ { SB_PACK( 4, 0, 4*4) , SB_PACK( 0,  9, 0*0) , SB_PACK( 9, 0, 1*1) , SB_PACK( 0, 19, 1*1) } },
	{ { SB_PACK( 5, 0, 3*3) , SB_PACK( 0,  9, 1*1) , SB_PACK( 9, 0, 2*2) , SB_PACK( 0, 19, 0*0) } },
	{ { SB_PACK( 5, 0, 2*2) , SB_PACK( 3,  7, 1*1) , SB_PACK(10, 0, 1*1) , SB_PACK( 0, 20, 1*1) } },
	{ { SB_PACK( 5, 0, 1*1) , SB_PACK( 3,  7, 0*0) , SB_PACK(10, 0, 0*0) , SB_PACK( 0, 20, 0*0) } },
	{ { SB_PACK( 5, 0, 0*0) , SB_PACK( 0, 10, 0*0) , SB_PACK(10, 0, 1*1) , SB_PACK( 0, 21, 1*1) } },
	{ { SB_PACK( 5, 0, 1*1) , SB_PACK( 0, 10, 1*1) , SB_PACK(10, 0, 2*2) , SB_PACK( 0, 21, 0*0) } },
	{ { SB_PACK( 5, 0, 2*2) , SB_PACK( 0, 10, 2*2) , SB_PACK(11, 0, 1*1) , SB_PACK( 0, 22, 1*1) } },
	{ { SB_PACK( 5, 0, 3*3) , SB_PACK( 0, 11, 1*1) , SB_PACK(11, 0, 0*0) , SB_PACK( 0, 22, 0*0) } },
	{ { SB_PACK( 5, 0, 4*4) , SB_PACK( 0, 11, 0*0) , SB_PACK(11, 0, 1*1) , SB_PACK( 0, 23, 1*1) } },
	{ { SB_PACK( 6, 0, 3*3) , SB_PACK( 0, 11, 1*1) , SB_PACK(11, 0, 2*2) , SB_PACK( 0, 23, 0*0) } },
	{ { SB_PACK( 6, 0, 2*2) , SB_PACK( 0, 11, 2*2) , SB_PACK(12, 0, 1*1) , SB_PACK( 0, 24, 1*1) } },
	{ { SB_PACK( 6, 0, 1*1) , SB_PACK( 0, 12, 1*1) , SB_PACK(12, 0, 0*0) , SB_PACK( 0, 24, 0*0) } },
	{ { SB_PACK( 6, 0, 0*0) , SB_PACK( 0, 12, 0*0) , SB_PACK(12, 0, 1*1) , SB_PACK( 0, 25, 1*1) } },
	{ { SB_PACK( 6, 0, 1*1) , SB_PACK( 0, 12, 1*1) , SB_PACK(12, 0, 2*2) , SB_PACK( 0, 25, 0*0) } },
	{ { SB_PACK( 6, 0, 2*2) , SB_PACK( 0, 12, 2*2) , SB_PACK(13, 0, 1*1) , SB_PACK( 0, 26, 1*1) } },
	{ { SB_PACK( 6, 0, 3*3) , SB_PACK( 0, 13, 1*1) , SB_PACK(13, 0, 0*0) , SB_PACK( 0, 26, 0*0) } },
	{ { SB_PACK( 6, 0, 4*4) , SB_PACK( 0, 13, 0*0) , SB_PACK(13, 0, 1*1) , SB_PACK( 0, 27, 1*1) } },
	{ { SB_PACK( 7, 0, 3*3) , SB_PACK( 0, 13, 1*1) , SB_PACK(13, 0, 2*2) , SB_PACK( 0, 27, 0*0) } },
	{ { SB_PACK( 7, 0, 2*2) , SB_PACK( 0, 13, 2*2) , SB_PACK(14, 0, 1*1) , SB_PACK( 0, 28, 1*1) } },
	{ { SB_PACK( 7, 0, 1*1) , SB_PACK( 0, 14, 1*1) , SB_PACK(14, 0, 0*0) , SB_PACK( 0, 28, 0*0) } },
	{ { SB_PACK( 7, 0, 0*0) , SB_PACK( 0, 14, 0*0) , SB_PACK(14, 0, 1*1) , SB_PACK( 0, 29, 1*1) } },
	{ { SB_PACK( 7, 0, 1*1) , SB_PACK( 0, 14, 1*1) , SB_PACK(14, 0, 2*2) , SB_PACK( 0, 29, 0*0) } },
	{ { SB_PACK( 7, 0, 2*2) , SB_PACK( 0, 14, 2*2) , SB_PACK(15, 0, 1*1) , SB_PACK( 0, 30, 1*1) } },
	{ { SB_PACK( 7, 0, 3*3) , SB_PACK( 0, 15, 1*1) , SB_PACK(15, 0, 0*0) , SB_PACK( 0, 30, 0*0) } },
	{ { SB_PACK( 7, 0, 4*4) , SB_PACK( 0, 15, 0*0) , SB_PACK(15, 0, 1*1) , SB_PACK( 0, 31, 1*1) } },
	{ { SB_PACK( 8, 0, 4*4) , SB_PACK( 0, 15, 1*1) , SB_PACK(15, 0, 2*2) , SB_PACK( 0, 31, 0*0) } },
	{ { SB_PACK( 8, 0, 3*3) , SB_PACK( 0, 15, 2*2) , SB_PACK(16, 0, 2*2) , SB_PACK( 1, 31, 1*1) } },
	{ { SB_PACK( 8, 0, 2*2) , SB_PACK( 1, 15, 1*1) , SB_PACK(16, 0, 1*1) , SB_PACK( 1, 31, 0*0) } },
	{ { SB_PACK( 8, 0, 1*1) , SB_PACK( 1, 15, 0*0) , SB_PACK(16, 0, 0*0) , SB_PACK( 0, 32, 0*0) } },
	{ { SB_PACK( 8, 0, 0*0) , SB_PACK( 0, 16, 0*0) , SB_PACK(16, 0, 1*1) , SB_PACK( 2, 31, 0*0) } },
	{ { SB_PACK( 8, 0, 1*1) , SB_PACK( 0, 16, 1*1) , SB_PACK(16, 0, 2*2) , SB_PACK( 0, 33, 0*0) } },
	{ { SB_PACK( 8, 0, 2*2) , SB_PACK( 2, 15, 1*1) , SB_PACK(17, 0, 1*1) , SB_PACK( 3, 31, 0*0) } },
	{ { SB_PACK( 8, 0, 3*3) , SB_PACK( 2, 15, 0*0) , SB_PACK(17, 0, 0*0) , SB_PACK( 0, 34, 0*0) } },
	{ { SB_PACK( 8, 0, 4*4) , SB_PACK( 0, 17, 0*0) , SB_PACK(17, 0, 1*1) , SB_PACK( 4, 31, 0*0) } },
	{ { SB_PACK( 9, 0, 3*3) , SB_PACK( 0, 17, 1*1) , SB_PACK(17, 0, 2*2) , SB_PACK( 0, 35, 0*0) } },
	{ { SB_PACK( 9, 0, 2*2) , SB_PACK( 3, 15, 1*1) , SB_PACK(18, 0, 1*1) , SB_PACK( 5, 31, 0*0) } },
	{ { SB_PACK( 9, 0, 1*1) , SB_PACK( 3, 15, 0*0) , SB_PACK(18, 0, 0*0) , SB_PACK( 0, 36, 0*0) } },
	{ { SB_PACK( 9, 0, 0*0) , SB_PACK( 0, 18, 0*0) , SB_PACK(18, 0, 1*1) , SB_PACK( 6, 31, 0*0) } },
	{ { SB_PACK( 9, 0, 1*1) , SB_PACK( 0, 18, 1*1) , SB_PACK(18, 0, 2*2) , SB_PACK( 0, 37, 0*0) } },
	{ { SB_PACK( 9, 0, 2*2) , SB_PACK( 0, 18, 2*2) , SB_PACK(19, 0, 1*1) , SB_PACK( 7, 31, 0*0) } },
	{ { SB_PACK( 9, 0, 3*3) , SB_PACK( 0, 19, 1*1) , SB_PACK(19, 0, 0*0) , SB_PACK( 0, 38, 0*0) } },
	{ { SB_PACK( 9, 0, 4*4) , SB_PACK( 0, 19, 0*0) , SB_PACK(19, 0, 1*1) , SB_PACK( 8, 31, 0*0) } },
	{ { SB_PACK(10, 0, 3*3) , SB_PACK( 0, 19, 1*1) , SB_PACK(19, 0, 2*2) , SB_PACK( 0, 39, 0*0) } },
	{ { SB_PACK(10, 0, 2*2) , SB_PACK( 0, 19, 2*2) , SB_PACK(20, 0, 1*1) , SB_PACK( 9, 31, 0*0) } },
	{ { SB_PACK(10, 0, 1*1) , SB_PACK( 0, 20, 1*1) , SB_PACK(20, 0, 0*0) , SB_PACK( 0, 40, 0*0) } },
	{ { SB_PACK(10, 0, 0*0) , SB_PACK( 0, 20, 0*0) , SB_PACK(20, 0, 1*1) , SB_PACK(10, 31, 0*0) } },
	{ { SB_PACK(10, 0, 1*1) , SB_PACK( 0, 20, 1*1) , SB_PACK(20, 0, 2*2) , SB_PACK( 0, 41, 0*0) } },
	{ { SB_PACK(10, 0, 2*2) , SB_PACK( 0, 20, 2*2) , SB_PACK(21, 0, 1*1) , SB_PACK(11, 31, 0*0) } },
	{ { SB_PACK(10, 0, 3*3) , SB_PACK( 0, 21, 1*1) , SB_PACK(21, 0, 0*0) , SB_PACK( 0, 42, 0*0) } },
	{ { SB_PACK(10, 0, 4*4) , SB_PACK( 0, 21, 0*0) , SB_PACK(21, 0, 1*1) , SB_PACK(12, 31, 0*0) } },
	{ { SB_PACK(11, 0, 3*3) , SB_PACK( 0, 21, 1*1) , SB_PACK(21, 0, 2*2) , SB_PACK( 0, 43, 0*0) } },
	{ { SB_PACK(11, 0, 2*2) , SB_PACK( 0, 21, 2*2) , SB_PACK(22, 0, 1*1) , SB_PACK(13, 31, 0*0) } },
	{ { SB_PACK(11, 0, 1*1) , SB_PACK( 0, 22, 1*1) , SB_PACK(22, 0, 0*0) , SB_PACK( 0, 44, 0*0) } },
	{ { SB_PACK(11, 0, 0*0) , SB_PACK( 0, 22, 0*0) , SB_PACK(22, 0, 1*1) , SB_PACK(14, 31, 0*0) } },
	{ { SB_PACK(11, 0, 1*1) , SB_PACK( 0, 22, 1*1) , SB_PACK(22, 0, 2*2) , SB_PACK( 0, 45, 0*0) } },
	{ { SB_PACK(11, 0, 2*2) , SB_PACK( 0, 22, 2*2) , SB_PACK(23, 0, 1*1) , SB_PACK(15, 31, 0*0) } },
	{ { SB_PACK(11, 0, 3*3) , SB_PACK( 0, 23, 1*1) , SB_PACK(23, 0, 0*0) , SB_PACK( 0, 46, 0*0) } },
	{ { SB_PACK(11, 0, 4*4) , SB_PACK( 0, 23, 0*0) , SB_PACK(23, 0, 1*1) , SB_PACK( 0, 47, 1*1) } },
	{ { SB_PACK(12, 0, 4*4) , SB_PACK( 0, 23, 1*1) , SB_PACK(23, 0, 2*2) , SB_PACK( 0, 47, 0*0) } },
	{ { SB_PACK(12, 0, 3*3) , SB_PACK( 0, 23, 2*2) , SB_PACK(24, 0, 1*1) , SB_PACK( 0, 48, 1*1) } },
	{ { SB_PACK(12, 0, 2*2) , SB_PACK( 1, 23, 1*1) , SB_PACK(24, 0, 0*0) , SB_PACK( 0, 48, 0*0) } },
	{ { SB_PACK(12, 0, 1*1) , SB_PACK( 1, 23, 0*0) , SB_PACK(24, 0, 1*1) , SB_PACK( 0, 49, 1*1) } },
	{ { SB_PACK(12, 0, 0*0) , SB_PACK( 0, 24, 0*0) , SB_PACK(24, 0, 2*2) , SB_PACK( 0, 49, 0*0) } },
	{ { SB_PACK(12, 0, 1*1) , SB_PACK( 0, 24, 1*1) , SB_PACK(25, 0, 1*1) , SB_PACK( 0, 50, 1*1) } },
	{ { SB_PACK(12, 0, 2*2) , SB_PACK( 2, 23, 1*1) , SB_PACK(25, 0, 0*0) , SB_PACK( 0, 50, 0*0) } },
	{ { SB_PACK(12, 0, 3*3) , SB_PACK( 2, 23, 0*0) , SB_PACK(25, 0, 1*1) , SB_PACK( 0, 51, 1*1) } },
	{ { SB_PACK(12, 0, 4*4) , SB_PACK( 0, 25, 0*0) , SB_PACK(25, 0, 2*2) , SB_PACK( 0, 51, 0*0) } },
	{ { SB_PACK(13, 0, 3*3) , SB_PACK( 0, 25, 1*1) , SB_PACK(26, 0, 1*1) , SB_PACK( 0, 52, 1*1) } },
	{ { SB_PACK(13, 0, 2*2) , SB_PACK( 3, 23, 1*1) , SB_PACK(26, 0, 0*0) , SB_PACK( 0, 52, 0*0) } },
	{ { SB_PACK(13, 0, 1*1) , SB_PACK( 3, 23, 0*0) , SB_PACK(26, 0, 1*1) , SB_PACK( 0, 53, 1*1) } },
	{ { SB_PACK(13, 0, 0*0) , SB_PACK( 0, 26, 0*0) , SB_PACK(26, 0, 2*2) , SB_PACK( 0, 53, 0*0) } },
	{ { SB_PACK(13, 0, 1*1) , SB_PACK( 0, 26, 1*1) , SB_PACK(27, 0, 1*1) , SB_PACK( 0, 54, 1*1) } },
	{ { SB_PACK(13, 0, 2*2) , SB_PACK( 0, 26, 2*2) , SB_PACK(27, 0, 0*0) , SB_PACK( 0, 54, 0*0) } },
	{ { SB_PACK(13, 0, 3*3) , SB_PACK( 0, 27, 1*1) , SB_PACK(27, 0, 1*1) , SB_PACK( 0, 55, 1*1) } },
	{ { SB_PACK(13, 0, 4*4) , SB_PACK( 0, 27, 0*0) , SB_PACK(27, 0, 2*2) , SB_PACK( 0, 55, 0*0) } },
	{ { SB_PACK(14, 0, 3*3) , SB_PACK( 0, 27, 1*1) , SB_PACK(28, 0, 1*1) , SB_PACK( 0, 56, 1*1) } },
	{ { SB_PACK(14, 0, 2*2) , SB_PACK( 0, 27, 2*2) , SB_PACK(28, 0, 0*0) , SB_PACK( 0, 56, 0*0) } },
	{ { SB_PACK(14, 0, 1*1) , SB_PACK( 0, 28, 1*1) , SB_PACK(28, 0, 1*1) , SB_PACK( 0, 57, 1*1) } },
	{ { SB_PACK(14, 0, 0*0) , SB_PACK( 0, 28, 0*0) , SB_PACK(28, 0, 2*2) , SB_PACK( 0, 57, 0*0) } },
	{ { SB_PACK(14, 0, 1*1) , SB_PACK( 0, 28, 1*1) , SB_PACK(29, 0, 1*1) , SB_PACK( 0, 58, 1*1) } },
	{ { SB_PACK(14, 0, 2*2) , SB_PACK( 0, 28, 2*2) , SB_PACK(29, 0, 0*0) , SB_PACK( 0, 58, 0*0) } },
	{ { SB_PACK(14, 0, 3*3) , SB_PACK( 0, 29, 1*1) , SB_PACK(29, 0, 1*1) , SB_PACK( 0, 59, 1*1) } },
	{ { SB_PACK(14, 0, 4*4) , SB_PACK( 0, 29, 0*0) , SB_PACK(29, 0, 2*2) , SB_PACK( 0, 59, 0*0) } },
	{ { SB_PACK(15, 0, 3*3) , SB_PACK( 0, 29, 1*1) , SB_PACK(30, 0, 1*1) , SB_PACK( 0, 60, 1*1) } },
	{ { SB_PACK(15, 0, 2*2) , SB_PACK( 0, 29, 2*2) , SB_PACK(30, 0, 0*0) , SB_PACK( 0, 60, 0*0) } },
	{ { SB_PACK(15, 0, 1*1) , SB_PACK( 0, 30, 1*1) , SB_PACK(30, 0, 1*1) , SB_PACK( 0, 61, 1*1) } },
	{ { SB_PACK(15, 0, 0*0) , SB_PACK( 0, 30, 0*0) , SB_PACK(30, 0, 2*2) , SB_PACK( 0, 61, 0*0) } },
	{ { SB_PACK(15, 0, 1*1) , SB_PACK( 0, 30, 1*1) , SB_PACK(31, 0, 1*1) , SB_PACK( 0, 62, 1*1) } },
	{ { SB_PACK(15, 0, 2*2) , SB_PACK( 0, 30, 2*2) , SB_PACK(31, 0, 0*0) , SB_PACK( 0, 62, 0*0) } },
	{ { SB_PACK(15, 0, 3*3) , SB_PACK( 0, 31, 1*1) , SB_PACK(31, 0, 1*1) , SB_PACK( 0, 63, 1*1) } },
	{ { SB_PACK(15, 0, 4*4) , SB_PACK( 0, 31, 0*0) , SB_PACK(31, 0, 2*2) , SB_PACK( 0, 63, 0*0) } },
	{ { SB_PACK(16, 0, 4*4) , SB_PACK( 0, 31, 1*1) , SB_PACK(32, 0, 2*2) , SB_PACK( 1, 63, 1*1) } },
	{ { SB_PACK(16, 0, 3*3) , SB_PACK( 0, 31, 2*2) , SB_PACK(32, 0, 1*1) , SB_PACK( 1, 63, 0*0) } },
	{ { SB_PACK(16, 0, 2*2) , SB_PACK( 1, 31, 1*1) , SB_PACK(32, 0, 0*0) , SB_PACK(16, 48, 0*0) } },
	{ { SB_PACK(16, 0, 1*1) , SB_PACK( 1, 31, 0*0) , SB_PACK(32, 0, 1*1) , SB_PACK( 2, 63, 0*0) } },
	{ { SB_PACK(16, 0, 0*0) , SB_PACK( 4, 28, 0*0) , SB_PACK(32, 0, 2*2) , SB_PACK(16, 49, 0*0) } },
	{ { SB_PACK(16, 0, 1*1) , SB_PACK( 4, 28, 1*1) , SB_PACK(33, 0, 1*1) , SB_PACK( 3, 63, 0*0) } },
	{ { SB_PACK(16, 0, 2*2) , SB_PACK( 2, 31, 1*1) , SB_PACK(33, 0, 0*0) , SB_PACK(16, 50, 0*0) } },
	{ { SB_PACK(16, 0, 3*3) , SB_PACK( 2, 31, 0*0) , SB_PACK(33, 0, 1*1) , SB_PACK( 4, 63, 0*0) } },
	{ { SB_PACK(16, 0, 4*4) , SB_PACK( 4, 29, 0*0) , SB_PACK(33, 0, 2*2) , SB_PACK(16, 51, 0*0) } },
	{ { SB_PACK(17, 0, 3*3) , SB_PACK( 4, 29, 1*1) , SB_PACK(34, 0, 1*1) , SB_PACK( 5, 63, 0*0) } },
	{ { SB_PACK(17, 0, 2*2) , SB_PACK( 3, 31, 1*1) , SB_PACK(34, 0, 0*0) , SB_PACK(16, 52, 0*0) } },
	{ { SB_PACK(17, 0, 1*1) , SB_PACK( 3, 31, 0*0) , SB_PACK(34, 0, 1*1) , SB_PACK( 6, 63, 0*0) } },
	{ { SB_PACK(17, 0, 0*0) , SB_PACK( 4, 30, 0*0) , SB_PACK(34, 0, 2*2) , SB_PACK(16, 53, 0*0) } },
	{ { SB_PACK(17, 0, 1*1) , SB_PACK( 4, 30, 1*1) , SB_PACK(35, 0, 1*1) , SB_PACK( 7, 63, 0*0) } },
	{ { SB_PACK(17, 0, 2*2) , SB_PACK( 4, 30, 2*2) , SB_PACK(35, 0, 0*0) , SB_PACK(16, 54, 0*0) } },
	{ { SB_PACK(17, 0, 3*3) , SB_PACK( 4, 31, 1*1) , SB_PACK(35, 0, 1*1) , SB_PACK( 8, 63, 0*0) } },
	{ { SB_PACK(17, 0, 4*4) , SB_PACK( 4, 31, 0*0) , SB_PACK(35, 0, 2*2) , SB_PACK(16, 55, 0*0) } },
	{ { SB_PACK(18, 0, 3*3) , SB_PACK( 4, 31, 1*1) , SB_PACK(36, 0, 1*1) , SB_PACK( 9, 63, 0*0) } },
	{ { SB_PACK(18, 0, 2*2) , SB_PACK( 4, 31, 2*2) , SB_PACK(36, 0, 0*0) , SB_PACK(16, 56, 0*0) } },
	{ { SB_PACK(18, 0, 1*1) , SB_PACK( 5, 31, 1*1) , SB_PACK(36, 0, 1*1) , SB_PACK(10, 63, 0*0) } },
	{ { SB_PACK(18, 0, 0*0) , SB_PACK( 5, 31, 0*0) , SB_PACK(36, 0, 2*2) , SB_PACK(16, 57, 0*0) } },
	{ { SB_PACK(18, 0, 1*1) , SB_PACK( 5, 31, 1*1) , SB_PACK(37, 0, 1*1) , SB_PACK(11, 63, 0*0) } },
	{ { SB_PACK(18, 0, 2*2) , SB_PACK( 5, 31, 2*2) , SB_PACK(37, 0, 0*0) , SB_PACK(16, 58, 0*0) } },
	{ { SB_PACK(18, 0, 3*3) , SB_PACK( 6, 31, 1*1) , SB_PACK(37, 0, 1*1) , SB_PACK(12, 63, 0*0) } },
	{ { SB_PACK(18, 0, 4*4) , SB_PACK( 6, 31, 0*0) , SB_PACK(37, 0, 2*2) , SB_PACK(16, 59, 0*0) } },
	{ { SB_PACK(19, 0, 3*3) , SB_PACK( 6, 31, 1*1) , SB_PACK(38, 0, 1*1) , SB_PACK(13, 63, 0*0) } },
	{ { SB_PACK(19, 0, 2*2) , SB_PACK( 6, 31, 2*2) , SB_PACK(38, 0, 0*0) , SB_PACK(16, 60, 0*0) } },
	{ { SB_PACK(19, 0, 1*1) , SB_PACK( 7, 31, 1*1) , SB_PACK(38, 0, 1*1) , SB_PACK(14, 63, 0*0) } },
	{ { SB_PACK(19, 0, 0*0) , SB_PACK( 7, 31, 0*0) , SB_PACK(38, 0, 2*2) , SB_PACK(16, 61, 0*0) } },
	{ { SB_PACK(19, 0, 1*1) , SB_PACK( 7, 31, 1*1) , SB_PACK(39, 0, 1*1) , SB_PACK(15, 63, 0*0) } },
	{ { SB_PACK(19, 0, 2*2) , SB_PACK( 7, 31, 2*2) , SB_PACK(39, 0, 0*0) , SB_PACK(16, 62, 0*0) } },
	{ { SB_PACK(19, 0, 3*3) , SB_PACK( 8, 31, 1*1) , SB_PACK(39, 0, 1*1) , SB_PACK(16, 63, 1*1) } },
	{ { SB_PACK(19, 0, 4*4) , SB_PACK( 8, 31, 0*0) , SB_PACK(39, 0, 2*2) , SB_PACK(16, 63, 0*0) } },
	{ { SB_PACK(20, 0, 4*4) , SB_PACK( 8, 31, 1*1) , SB_PACK(40, 0, 1*1) , SB_PACK(17, 63, 1*1) } },
	{ { SB_PACK(20, 0, 3*3) , SB_PACK( 8, 31, 2*2) , SB_PACK(40, 0, 0*0) , SB_PACK(17, 63, 0*0) } },
	{ { SB_PACK(20, 0, 2*2) , SB_PACK( 9, 31, 1*1) , SB_PACK(40, 0, 1*1) , SB_PACK(18, 63, 1*1) } },
	{ { SB_PACK(20, 0, 1*1) , SB_PACK( 9, 31, 0*0) , SB_PACK(40, 0, 2*2) , SB_PACK(18, 63, 0*0) } },
	{ { SB_PACK(20, 0, 0*0) , SB_PACK(12, 28, 0*0) , SB_PACK(41, 0, 1*1) , SB_PACK(19, 63, 1*1) } },
	{ { SB_PACK(20, 0, 1*1) , SB_PACK(12, 28, 1*1) , SB_PACK(41, 0, 0*0) , SB_PACK(19, 63, 0*0) } },
	{ { SB_PACK(20, 0, 2*2) , SB_PACK(10, 31, 1*1) , SB_PACK(41, 0, 1*1) , SB_PACK(20, 63, 1*1) } },
	{ { SB_PACK(20, 0, 3*3) , SB_PACK(10, 31, 0*0) , SB_PACK(41, 0, 2*2) , SB_PACK(20, 63, 0*0) } },
	{ { SB_PACK(20, 0, 4*4) , SB_PACK(12, 29, 0*0) , SB_PACK(42, 0, 1*1) , SB_PACK(21, 63, 1*1) } },
	{ { SB_PACK(21, 0, 3*3) , SB_PACK(12, 29, 1*1) , SB_PACK(42, 0, 0*0) , SB_PACK(21, 63, 0*0) } },
	{ { SB_PACK(21, 0, 2*2) , SB_PACK(11, 31, 1*1) , SB_PACK(42, 0, 1*1) , SB_PACK(22, 63, 1*1) } },
	{ { SB_PACK(21, 0, 1*1) , SB_PACK(11, 31, 0*0) , SB_PACK(42, 0, 2*2) , SB_PACK(22, 63, 0*0) } },
	{ { SB_PACK(21, 0, 0*0) , SB_PACK(12, 30, 0*0) , SB_PACK(43, 0, 1*1) , SB_PACK(23, 63, 1*1) } },
	{ { SB_PACK(21, 0, 1*1) , SB_PACK(12, 30, 1*1) , SB_PACK(43, 0, 0*0) , SB_PACK(23, 63, 0*0) } },
	{ { SB_PACK(21, 0, 2*2) , SB_PACK(12, 30, 2*2) , SB_PACK(43, 0, 1*1) , SB_PACK(24, 63, 1*1) } },
	{ { SB_PACK(21, 0, 3*3) , SB_PACK(12, 31, 1*1) , SB_PACK(43, 0, 2*2) , SB_PACK(24, 63, 0*0) } },
	{ { SB_PACK(21, 0, 4*4) , SB_PACK(12, 31, 0*0) , SB_PACK(44, 0, 1*1) , SB_PACK(25, 63, 1*1) } },
	{ { SB_PACK(22, 0, 3*3) , SB_PACK(12, 31, 1*1) , SB_PACK(44, 0, 0*0) , SB_PACK(25, 63, 0*0) } },
	{ { SB_PACK(22, 0, 2*2) , SB_PACK(12, 31, 2*2) , SB_PACK(44, 0, 1*1) , SB_PACK(26, 63, 1*1) } },
	{ { SB_PACK(22, 0, 1*1) , SB_PACK(13, 31, 1*1) , SB_PACK(44, 0, 2*2) , SB_PACK(26, 63, 0*0) } },
	{ { SB_PACK(22, 0, 0*0) , SB_PACK(13, 31, 0*0) , SB_PACK(45, 0, 1*1) , SB_PACK(27, 63, 1*1) } },
	{ { SB_PACK(22, 0, 1*1) , SB_PACK(13, 31, 1*1) , SB_PACK(45, 0, 0*0) , SB_PACK(27, 63, 0*0) } },
	{ { SB_PACK(22, 0, 2*2) , SB_PACK(13, 31, 2*2) , SB_PACK(45, 0, 1*1) , SB_PACK(28, 63, 1*1) } },
	{ { SB_PACK(22, 0, 3*3) , SB_PACK(14, 31, 1*1) , SB_PACK(45, 0, 2*2) , SB_PACK(28, 63, 0*0) } },
	{ { SB_PACK(22, 0, 4*4) , SB_PACK(14, 31, 0*0) , SB_PACK(46, 0, 1*1) , SB_PACK(29, 63, 1*1) } },
	{ { SB_PACK(23, 0, 3*3) , SB_PACK(14, 31, 1*1) , SB_PACK(46, 0, 0*0) , SB_PACK(29, 63, 0*0) } },
	{ { SB_PACK(23, 0, 2*2) , SB_PACK(14, 31, 2*2) , SB_PACK(46, 0, 1*1) , SB_PACK(30, 63, 1*1) } },
	{ { SB_PACK(23, 0, 1*1) , SB_PACK(15, 31, 1*1) , SB_PACK(46, 0, 2*2) , SB_PACK(30, 63, 0*0) } },
	{ { SB_PACK(23, 0, 0*0) , SB_PACK(15, 31, 0*0) , SB_PACK(47, 0, 1*1) , SB_PACK(31, 63, 1*1) } },
	{ { SB_PACK(23, 0, 1*1) , SB_PACK(15, 31, 1*1) , SB_PACK(47, 0, 0*0) , SB_PACK(31, 63, 0*0) } },
	{ { SB_PACK(23, 0, 2*2) , SB_PACK(15, 31, 2*2) , SB_PACK(47, 0, 1*1) , SB_PACK(32, 63, 1*1) } },
	{ { SB_PACK(23, 0, 3*3) , SB_PACK(16, 31, 1*1) , SB_PACK(47, 0, 2*2) , SB_PACK(32, 63, 0*0) } },
	{ { SB_PACK(23, 0, 4*4) , SB_PACK(16, 31, 0*0) , SB_PACK(48, 0, 2*2) , SB_PACK(33, 63, 1*1) } },
	{ { SB_PACK(24, 0, 4*4) , SB_PACK(16, 31, 1*1) , SB_PACK(48, 0, 1*1) , SB_PACK(33, 63, 0*0) } },
	{ { SB_PACK(24, 0, 3*3) , SB_PACK(16, 31, 2*2) , SB_PACK(48, 0, 0*0) , SB_PACK(48, 48, 0*0) } },
	{ { SB_PACK(24, 0, 2*2) , SB_PACK(17, 31, 1*1) , SB_PACK(48, 0, 1*1) , SB_PACK(34, 63, 0*0) } },
	{ { SB_PACK(24, 0, 1*1) , SB_PACK(17, 31, 0*0) , SB_PACK(48, 0, 2*2) , SB_PACK(48, 49, 0*0) } },
	{ { SB_PACK(24, 0, 0*0) , SB_PACK(20, 28, 0*0) , SB_PACK(49, 0, 1*1) , SB_PACK(35, 63, 0*0) } },
	{ { SB_PACK(24, 0, 1*1) , SB_PACK(20, 28, 1*1) , SB_PACK(49, 0, 0*0) , SB_PACK(48, 50, 0*0) } },
	{ { SB_PACK(24, 0, 2*2) , SB_PACK(18, 31, 1*1) , SB_PACK(49, 0, 1*1) , SB_PACK(36, 63, 0*0) } },
	{ { SB_PACK(24, 0, 3*3) , SB_PACK(18, 31, 0*0) , SB_PACK(49, 0, 2*2) , SB_PACK(48, 51, 0*0) } },
	{ { SB_PACK(24, 0, 4*4) , SB_PACK(20, 29, 0*0) , SB_PACK(50, 0, 1*1) , SB_PACK(37, 63, 0*0) } },
	{ { SB_PACK(25, 0, 3*3) , SB_PACK(20, 29, 1*1) , SB_PACK(50, 0, 0*0) , SB_PACK(48, 52, 0*0) } },
	{ { SB_PACK(25, 0, 2*2) , SB_PACK(19, 31, 1*1) , SB_PACK(50, 0, 1*1) , SB_PACK(38, 63, 0*0) } },
	{ { SB_PACK(25, 0, 1*1) , SB_PACK(19, 31, 0*0) , SB_PACK(50, 0, 2*2) , SB_PACK(48, 53, 0*0) } },
	{ { SB_PACK(25, 0, 0*0) , SB_PACK(20, 30, 0*0) , SB_PACK(51, 0, 1*1) , SB_PACK(39, 63, 0*0) } },
	{ { SB_PACK(25, 0, 1*1) , SB_PACK(20, 30, 1*1) , SB_PACK(51, 0, 0*0) , SB_PACK(48, 54, 0*0) } },
	{ { SB_PACK(25, 0, 2*2) , SB_PACK(20, 30, 2*2) , SB_PACK(51, 0, 1*1) , SB_PACK(40, 63, 0*0) } },
	{ { SB_PACK(25, 0, 3*3) , SB_PACK(20, 31, 1*1) , SB_PACK(51, 0, 2*2) , SB_PACK(48, 55, 0*0) } },
	{ { SB_PACK(25, 0, 4*4) , SB_PACK(20, 31, 0*0) , SB_PACK(52, 0, 1*1) , SB_PACK(41, 63, 0*0) } },
	{ { SB_PACK(26, 0, 3*3) , SB_PACK(20, 31, 1*1) , SB_PACK(52, 0, 0*0) , SB_PACK(48, 56, 0*0) } },
	{ { SB_PACK(26, 0, 2*2) , SB_PACK(20, 31, 2*2) , SB_PACK(52, 0, 1*1) , SB_PACK(42, 63, 0*0) } },
	{ { SB_PACK(26, 0, 1*1) , SB_PACK(21, 31, 1*1) , SB_PACK(52, 0, 2*2) , SB_PACK(48, 57, 0*0) } },
	{ { SB_PACK(26, 0, 0*0) , SB_PACK(21, 31, 0*0) , SB_PACK(53, 0, 1*1) , SB_PACK(43, 63, 0*0) } },
	{ { SB_PACK(26, 0, 1*1) , SB_PACK(21, 31, 1*1) , SB_PACK(53, 0, 0*0) , SB_PACK(48, 58, 0*0) } },
	{ { SB_PACK(26, 0, 2*2) , SB_PACK(21, 31, 2*2) , SB_PACK(53, 0, 1*1) , SB_PACK(44, 63, 0*0) } },
	{ { SB_PACK(26, 0, 3*3) , SB_PACK(22, 31, 1*1) , SB_PACK(53, 0, 2*2) , SB_PACK(48, 59, 0*0) } },
	{ { SB_PACK(26, 0, 4*4) , SB_PACK(22, 31, 0*0) , SB_PACK(54, 0, 1*1) , SB_PACK(45, 63, 0*0) } },
	{ { SB_PACK(27, 0, 3*3) , SB_PACK(22, 31, 1*1) , SB_PACK(54, 0, 0*0) , SB_PACK(48, 60, 0*0) } },
	{ { SB_PACK(27, 0, 2*2) , SB_PACK(22, 31, 2*2) , SB_PACK(54, 0, 1*1) , SB_PACK(46, 63, 0*0) } },
	{ { SB_PACK(27, 0, 1*1) , SB_PACK(23, 31, 1*1) , SB_PACK(54, 0, 2*2) , SB_PACK(48, 61, 0*0) } },
	{ { SB_PACK(27, 0, 0*0) , SB_PACK(23, 31, 0*0) , SB_PACK(55, 0, 1*1) , SB_PACK(47, 63, 0*0) } },
	{ { SB_PACK(27, 0, 1*1) , SB_PACK(23, 31, 1*1) , SB_PACK(55, 0, 0*0) , SB_PACK(48, 62, 0*0) } },
	{ { SB_PACK(27, 0, 2*2) , SB_PACK(23, 31, 2*2) , SB_PACK(55, 0, 1*1) , SB_PACK(48, 63, 1*1) } },
	{ { SB_PACK(27, 0, 3*3) , SB_PACK(24, 31, 1*1) , SB_PACK(55, 0, 2*2) , SB_PACK(48, 63, 0*0) } },
	{ { SB_PACK(27, 0, 4*4) , SB_PACK(24, 31, 0*0) , SB_PACK(56, 0, 1*1) , SB_PACK(49, 63, 1*1) } },
	{ { SB_PACK(28, 0, 4*4) , SB_PACK(24, 31, 1*1) , SB_PACK(56, 0, 0*0) , SB_PACK(49, 63, 0*0) } },
	{ { SB_PACK(28, 0, 3*3) , SB_PACK(24, 31, 2*2) , SB_PACK(56, 0, 1*1) , SB_PACK(50, 63, 1*1) } },
	{ { SB_PACK(28, 0, 2*2) , SB_PACK(25, 31, 1*1) , SB_PACK(56, 0, 2*2) , SB_PACK(50, 63, 0*0) } },
	{ { SB_PACK(28, 0, 1*1) , SB_PACK(25, 31, 0*0) , SB_PACK(57, 0, 1*1) , SB_PACK(51, 63, 1*1) } },
	{ { SB_PACK(28, 0, 0*0) , SB_PACK(28, 28, 0*0) , SB_PACK(57, 0, 0*0) , SB_PACK(51, 63, 0*0) } },
	{ { SB_PACK(28, 0, 1*1) , SB_PACK(28, 28, 1*1) , SB_PACK(57, 0, 1*1) , SB_PACK(52, 63, 1*1) } },
	{ { SB_PACK(28, 0, 2*2) , SB_PACK(26, 31, 1*1) , SB_PACK(57, 0, 2*2) , SB_PACK(52, 63, 0*0) } },
	{ { SB_PACK(28, 0, 3*3) , SB_PACK(26, 31, 0*0) , SB_PACK(58, 0, 1*1) , SB_PACK(53, 63, 1*1) } },
	{ { SB_PACK(28, 0, 4*4) , SB_PACK(28, 29, 0*0) , SB_PACK(58, 0, 0*0) , SB_PACK(53, 63, 0*0) } },
	{ { SB_PACK(29, 0, 3*3) , SB_PACK(28, 29, 1*1) , SB_PACK(58, 0, 1*1) , SB_PACK(54, 63, 1*1) } },
	{ { SB_PACK(29, 0, 2*2) , SB_PACK(27, 31, 1*1) , SB_PACK(58, 0, 2*2) , SB_PACK(54, 63, 0*0) } },
	{ { SB_PACK(29, 0, 1*1) , SB_PACK(27, 31, 0*0) , SB_PACK(59, 0, 1*1) , SB_PACK(55, 63, 1*1) } },
	{ { SB_PACK(29, 0, 0*0) , SB_PACK(28, 30, 0*0) , SB_PACK(59, 0, 0*0) , SB_PACK(55, 63, 0*0) } },
	{ { SB_PACK(29, 0, 1*1) , SB_PACK(28, 30, 1*1) , SB_PACK(59, 0, 1*1) , SB_PACK(56, 63, 1*1) } },
	{ { SB_PACK(29, 0, 2*2) , SB_PACK(28, 30, 2*2) , SB_PACK(59, 0, 2*2) , SB_PACK(56, 63, 0*0) } },
	{ { SB_PACK(29, 0, 3*3) , SB_PACK(28, 31, 1*1) , SB_PACK(60, 0, 1*1) , SB_PACK(57, 63, 1*1) } },
	{ { SB_PACK(29, 0, 4*4) , SB_PACK(28, 31, 0*0) , SB_PACK(60, 0, 0*0) , SB_PACK(57, 63, 0*0) } },
	{ { SB_PACK(30, 0, 3*3) , SB_PACK(28, 31, 1*1) , SB_PACK(60, 0, 1*1) , SB_PACK(58, 63, 1*1) } },
	{ { SB_PACK(30, 0, 2*2) , SB_PACK(28, 31, 2*2) , SB_PACK(60, 0, 2*2) , SB_PACK(58, 63, 0*0) } },
	{ { SB_PACK(30, 0, 1*1) , SB_PACK(29, 31, 1*1) , SB_PACK(61, 0, 1*1) , SB_PACK(59, 63, 1*1) } },
	{ { SB_PACK(30, 0, 0*0) , SB_PACK(29, 31, 0*0) , SB_PACK(61, 0, 0*0) , SB_PACK(59, 63, 0*0) } },
	{ { SB_PACK(30, 0, 1*1) , SB_PACK(29, 31, 1*1) , SB_PACK(61, 0, 1*1) , SB_PACK(60, 63, 1*1) } },
	{ { SB_PACK(30, 0, 2*2) , SB_PACK(29, 31, 2*2) , SB_PACK(61, 0, 2*2) , SB_PACK(60, 63, 0*0) } },
	{ { SB_PACK(30, 0, 3*3) , SB_PACK(30, 31, 1*1) , SB_PACK(62, 0, 1*1) , SB_PACK(61, 63, 1*1) } },
	{ { SB_PACK(30, 0, 4*4) , SB_PACK(30, 31, 0*0) , SB_PACK(62, 0, 0*0) , SB_PACK(61, 63, 0*0) } },
	{ { SB_PACK(31, 0, 3*3) , SB_PACK(30, 31, 1*1) , SB_PACK(62, 0, 1*1) , SB_PACK(62, 63, 1*1) } },
	{ { SB_PACK(31, 0, 2*2) , SB_PACK(30, 31, 2*2) , SB_PACK(62, 0, 2*2) , SB_PACK(62, 63, 0*0) } },
	{ { SB_PACK(31, 0, 1*1) , SB_PACK(31, 31, 1*1) , SB_PACK(63, 0, 1*1) , SB_PACK(63, 63, 1*1) } },
	{ { SB_PACK(31, 0, 0*0) , SB_PACK(31, 31, 0*0) , SB_PACK(63, 0, 0*0) , SB_PACK(63, 63, 0*0) } }
},
{ /* 4-step line */
	/* 5-bit color */                                          /* 6-bit color */
	{ { SB_PACK( 0, 0, 0*0) , SB_PACK( 0,  0, 0*0) , SB_PACK( 0, 0, 0*0) , SB_PACK( 0,  0, 0*0) } },
	{ { SB_PACK( 0, 0, 1*1) , SB_PACK( 0,  1, 1*1) , SB_PACK( 0, 0, 1*1) , SB_PACK( 0,  1, 0*0) } },
	{ { SB_PACK( 0, 0, 2*2) , SB_PACK( 0,  1, 0*0) , SB_PACK( 0, 0, 2*2) , SB_PACK( 0,  2, 0*0) } },
	{ { SB_PACK( 0, 0, 3*3) , SB_PACK( 0,  1, 1*1) , SB_PACK( 1, 0, 1*1) , SB_PACK( 0,  3, 1*1) } },
	{ { SB_PACK( 0, 0, 4*4) , SB_PACK( 0,  2, 1*1) , SB_PACK( 1, 0, 0*0) , SB_PACK( 0,  3, 0*0) } },
	{ { SB_PACK( 1, 0, 3*3) , SB_PACK( 0,  2, 0*0) , SB_PACK( 1, 0, 1*1) , SB_PACK( 0,  4, 0*0) } },
	{ { SB_PACK( 1, 0, 2*2) , SB_PACK( 0,  2, 1*1) , SB_PACK( 1, 0, 2*2) , SB_PACK( 0,  5, 0*0) } },
	{ { SB_PACK( 1, 0, 1*1) , SB_PACK( 0,  3, 1*1) , SB_PACK( 2, 0, 1*1) , SB_PACK( 0,  6, 1*1) } },
	{ { SB_PACK( 1, 0, 0*0) , SB_PACK( 0,  3, 0*0) , SB_PACK( 2, 0, 0*0) , SB_PACK( 0,  6, 0*0) } },
	{ { SB_PACK( 1, 0, 1*1) , SB_PACK( 1,  2, 1*1) , SB_PACK( 2, 0, 1*1) , SB_PACK( 0,  7, 0*0) } },
	{ { SB_PACK( 1, 0, 2*2) , SB_PACK( 1,  2, 0*0) , SB_PACK( 2, 0, 2*2) , SB_PACK( 0,  8, 0*0) } },
	{ { SB_PACK( 1, 0, 3*3) , SB_PACK( 0,  4, 0*0) , SB_PACK( 3, 0, 1*1) , SB_PACK( 0,  9, 1*1) } },
	{ { SB_PACK( 1, 0, 4*4) , SB_PACK( 0,  5, 1*1) , SB_PACK( 3, 0, 0*0) , SB_PACK( 0,  9, 0*0) } },
	{ { SB_PACK( 2, 0, 3*3) , SB_PACK( 0,  5, 0*0) , SB_PACK( 3, 0, 1*1) , SB_PACK( 0, 10, 0*0) } },
	{ { SB_PACK( 2, 0, 2*2) , SB_PACK( 0,  5, 1*1) , SB_PACK( 3, 0, 2*2) , SB_PACK( 0, 11, 0*0) } },
	{ { SB_PACK( 2, 0, 1*1) , SB_PACK( 0,  6, 1*1) , SB_PACK( 4, 0, 1*1) , SB_PACK( 0, 12, 1*1) } },
	{ { SB_PACK( 2, 0, 0*0) , SB_PACK( 0,  6, 0*0) , SB_PACK( 4, 0, 0*0) , SB_PACK( 0, 12, 0*0) } },
	{ { SB_PACK( 2, 0, 1*1) , SB_PACK( 2,  3, 1*1) , SB_PACK( 4, 0, 1*1) , SB_PACK( 0, 13, 0*0) } },
	{ { SB_PACK( 2, 0, 2*2) , SB_PACK( 2,  3, 0*0) , SB_PACK( 4, 0, 2*2) , SB_PACK( 0, 14, 0*0) } },
	{ { SB_PACK( 2, 0, 3*3) , SB_PACK( 0,  7, 0*0) , SB_PACK( 5, 0, 1*1) , SB_PACK( 0, 15, 1*1) } },
	{ { SB_PACK( 2, 0, 4*4) , SB_PACK( 1,  6, 1*1) , SB_PACK( 5, 0, 0*0) , SB_PACK( 0, 15, 0*0) } },
	{ { SB_PACK( 3, 0, 3*3) , SB_PACK( 1,  6, 0*0) , SB_PACK( 5, 0, 1*1) , SB_PACK( 0, 16, 0*0) } },
	{ { SB_PACK( 3, 0, 2*2) , SB_PACK( 0,  8, 0*0) , SB_PACK( 5, 0, 2*2) , SB_PACK( 1, 15, 0*0) } },
	{ { SB_PACK( 3, 0, 1*1) , SB_PACK( 0,  9, 1*1) , SB_PACK( 6, 0, 1*1) , SB_PACK( 0, 17, 0*0) } },
	{ { SB_PACK( 3, 0, 0*0) , SB_PACK( 0,  9, 0*0) , SB_PACK( 6, 0, 0*0) , SB_PACK( 0, 18, 0*0) } },
	{ { SB_PACK( 3, 0, 1*1) , SB_PACK( 0,  9, 1*1) , SB_PACK( 6, 0, 1*1) , SB_PACK( 0, 19, 0*0) } },
	{ { SB_PACK( 3, 0, 2*2) , SB_PACK( 0, 10, 1*1) , SB_PACK( 6, 0, 2*2) , SB_PACK( 3, 14, 0*0) } },
	{ { SB_PACK( 3, 0, 3*3) , SB_PACK( 0, 10, 0*0) , SB_PACK( 7, 0, 1*1) , SB_PACK( 0, 20, 0*0) } },
	{ { SB_PACK( 3, 0, 4*4) , SB_PACK( 2,  7, 1*1) , SB_PACK( 7, 0, 0*0) , SB_PACK( 0, 21, 0*0) } },
	{ { SB_PACK( 4, 0, 4*4) , SB_PACK( 2,  7, 0*0) , SB_PACK( 7, 0, 1*1) , SB_PACK( 0, 22, 0*0) } },
	{ { SB_PACK( 4, 0, 3*3) , SB_PACK( 0, 11, 0*0) , SB_PACK( 7, 0, 2*2) , SB_PACK( 4, 15, 0*0) } },
	{ { SB_PACK( 4, 0, 2*2) , SB_PACK( 1, 10, 1*1) , SB_PACK( 8, 0, 1*1) , SB_PACK( 0, 23, 0*0) } },
	{ { SB_PACK( 4, 0, 1*1) , SB_PACK( 1, 10, 0*0) , SB_PACK( 8, 0, 0*0) , SB_PACK( 0, 24, 0*0) } },
	{ { SB_PACK( 4, 0, 0*0) , SB_PACK( 0, 12, 0*0) , SB_PACK( 8, 0, 1*1) , SB_PACK( 0, 25, 0*0) } },
	{ { SB_PACK( 4, 0, 1*1) , SB_PACK( 0, 13, 1*1) , SB_PACK( 8, 0, 2*2) , SB_PACK( 6, 14, 0*0) } },
	{ { SB_PACK( 4, 0, 2*2) , SB_PACK( 0, 13, 0*0) , SB_PACK( 9, 0, 1*1) , SB_PACK( 0, 26, 0*0) } },
	{ { SB_PACK( 4, 0, 3*3) , SB_PACK( 0, 13, 1*1) , SB_PACK( 9, 0, 0*0) , SB_PACK( 0, 27, 0*0) } },
	{ { SB_PACK( 4, 0, 4*4) , SB_PACK( 0, 14, 1*1) , SB_PACK( 9, 0, 1*1) , SB_PACK( 0, 28, 0*0) } },
	{ { SB_PACK( 5, 0, 3*3) , SB_PACK( 0, 14, 0*0) , SB_PACK( 9, 0, 2*2) , SB_PACK( 7, 15, 0*0) } },
	{ { SB_PACK( 5, 0, 2*2) , SB_PACK( 2, 11, 1*1) , SB_PACK(10, 0, 1*1) , SB_PACK( 0, 29, 0*0) } },
	{ { SB_PACK( 5, 0, 1*1) , SB_PACK( 2, 11, 0*0) , SB_PACK(10, 0, 0*0) , SB_PACK( 0, 30, 0*0) } },
	{ { SB_PACK( 5, 0, 0*0) , SB_PACK( 0, 15, 0*0) , SB_PACK(10, 0, 1*1) , SB_PACK( 0, 31, 0*0) } },
	{ { SB_PACK( 5, 0, 1*1) , SB_PACK( 1, 14, 1*1) , SB_PACK(10, 0, 2*2) , SB_PACK( 9, 14, 0*0) } },
	{ { SB_PACK( 5, 0, 2*2) , SB_PACK( 1, 14, 0*0) , SB_PACK(11, 0, 1*1) , SB_PACK( 0, 32, 0*0) } },
	{ { SB_PACK( 5, 0, 3*3) , SB_PACK( 0, 16, 0*0) , SB_PACK(11, 0, 0*0) , SB_PACK( 0, 33, 0*0) } },
	{ { SB_PACK( 5, 0, 4*4) , SB_PACK( 0, 17, 1*1) , SB_PACK(11, 0, 1*1) , SB_PACK( 2, 30, 0*0) } },
	{ { SB_PACK( 6, 0, 3*3) , SB_PACK( 0, 17, 0*0) , SB_PACK(11, 0, 2*2) , SB_PACK( 0, 34, 0*0) } },
	{ { SB_PACK( 6, 0, 2*2) , SB_PACK( 0, 17, 1*1) , SB_PACK(12, 0, 1*1) , SB_PACK( 0, 35, 0*0) } },
	{ { SB_PACK( 6, 0, 1*1) , SB_PACK( 0, 18, 1*1) , SB_PACK(12, 0, 0*0) , SB_PACK( 0, 36, 0*0) } },
	{ { SB_PACK( 6, 0, 0*0) , SB_PACK( 0, 18, 0*0) , SB_PACK(12, 0, 1*1) , SB_PACK( 3, 31, 0*0) } },
	{ { SB_PACK( 6, 0, 1*1) , SB_PACK( 2, 15, 1*1) , SB_PACK(12, 0, 2*2) , SB_PACK( 0, 37, 0*0) } },
	{ { SB_PACK( 6, 0, 2*2) , SB_PACK( 2, 15, 0*0) , SB_PACK(13, 0, 1*1) , SB_PACK( 0, 38, 0*0) } },
	{ { SB_PACK( 6, 0, 3*3) , SB_PACK( 0, 19, 0*0) , SB_PACK(13, 0, 0*0) , SB_PACK( 0, 39, 0*0) } },
	{ { SB_PACK( 6, 0, 4*4) , SB_PACK( 1, 18, 1*1) , SB_PACK(13, 0, 1*1) , SB_PACK( 5, 30, 0*0) } },
	{ { SB_PACK( 7, 0, 3*3) , SB_PACK( 1, 18, 0*0) , SB_PACK(13, 0, 2*2) , SB_PACK( 0, 40, 0*0) } },
	{ { SB_PACK( 7, 0, 2*2) , SB_PACK( 0, 20, 0*0) , SB_PACK(14, 0, 1*1) , SB_PACK( 0, 41, 0*0) } },
	{ { SB_PACK( 7, 0, 1*1) , SB_PACK( 0, 21, 1*1) , SB_PACK(14, 0, 0*0) , SB_PACK( 0, 42, 0*0) } },
	{ { SB_PACK( 7, 0, 0*0) , SB_PACK( 0, 21, 0*0) , SB_PACK(14, 0, 1*1) , SB_PACK( 6, 31, 0*0) } },
	{ { SB_PACK( 7, 0, 1*1) , SB_PACK( 0, 21, 1*1) , SB_PACK(14, 0, 2*2) , SB_PACK( 0, 43, 0*0) } },
	{ { SB_PACK( 7, 0, 2*2) , SB_PACK( 0, 22, 1*1) , SB_PACK(15, 0, 1*1) , SB_PACK( 0, 44, 0*0) } },
	{ { SB_PACK( 7, 0, 3*3) , SB_PACK( 0, 22, 0*0) , SB_PACK(15, 0, 0*0) , SB_PACK( 0, 45, 0*0) } },
	{ { SB_PACK( 7, 0, 4*4) , SB_PACK( 2, 19, 1*1) , SB_PACK(15, 0, 1*1) , SB_PACK( 8, 30, 0*0) } },
	{ { SB_PACK( 8, 0, 4*4) , SB_PACK( 2, 19, 0*0) , SB_PACK(15, 0, 2*2) , SB_PACK( 0, 46, 0*0) } },
	{ { SB_PACK( 8, 0, 3*3) , SB_PACK( 0, 23, 0*0) , SB_PACK(16, 0, 2*2) , SB_PACK( 0, 47, 0*0) } },
	{ { SB_PACK( 8, 0, 2*2) , SB_PACK( 1, 22, 1*1) , SB_PACK(16, 0, 1*1) , SB_PACK( 1, 46, 0*0) } },
	{ { SB_PACK( 8, 0, 1*1) , SB_PACK( 1, 22, 0*0) , SB_PACK(16, 0, 0*0) , SB_PACK( 0, 48, 0*0) } },
	{ { SB_PACK( 8, 0, 0*0) , SB_PACK( 0, 24, 0*0) , SB_PACK(16, 0, 1*1) , SB_PACK( 0, 49, 0*0) } },
	{ { SB_PACK( 8, 0, 1*1) , SB_PACK( 0, 25, 1*1) , SB_PACK(16, 0, 2*2) , SB_PACK( 0, 50, 0*0) } },
	{ { SB_PACK( 8, 0, 2*2) , SB_PACK( 0, 25, 0*0) , SB_PACK(17, 0, 1*1) , SB_PACK( 2, 47, 0*0) } },
	{ { SB_PACK( 8, 0, 3*3) , SB_PACK( 0, 25, 1*1) , SB_PACK(17, 0, 0*0) , SB_PACK( 0, 51, 0*0) } },
	{ { SB_PACK( 8, 0, 4*4) , SB_PACK( 0, 26, 1*1) , SB_PACK(17, 0, 1*1) , SB_PACK( 0, 52, 0*0) } },
	{ { SB_PACK( 9, 0, 3*3) , SB_PACK( 0, 26, 0*0) , SB_PACK(17, 0, 2*2) , SB_PACK( 0, 53, 0*0) } },
	{ { SB_PACK( 9, 0, 2*2) , SB_PACK( 2, 23, 1*1) , SB_PACK(18, 0, 1*1) , SB_PACK( 4, 46, 0*0) } },
	{ { SB_PACK( 9, 0, 1*1) , SB_PACK( 2, 23, 0*0) , SB_PACK(18, 0, 0*0) , SB_PACK( 0, 54, 0*0) } },
	{ { SB_PACK( 9, 0, 0*0) , SB_PACK( 0, 27, 0*0) , SB_PACK(18, 0, 1*1) , SB_PACK( 0, 55, 0*0) } },
	{ { SB_PACK( 9, 0, 1*1) , SB_PACK( 1, 26, 1*1) , SB_PACK(18, 0, 2*2) , SB_PACK( 0, 56, 0*0) } },
	{ { SB_PACK( 9, 0, 2*2) , SB_PACK( 1, 26, 0*0) , SB_PACK(19, 0, 1*1) , SB_PACK( 5, 47, 0*0) } },
	{ { SB_PACK( 9, 0, 3*3) , SB_PACK( 0, 28, 0*0) , SB_PACK(19, 0, 0*0) , SB_PACK( 0, 57, 0*0) } },
	{ { SB_PACK( 9, 0, 4*4) , SB_PACK( 0, 29, 1*1) , SB_PACK(19, 0, 1*1) , SB_PACK( 0, 58, 0*0) } },
	{ { SB_PACK(10, 0, 3*3) , SB_PACK( 0, 29, 0*0) , SB_PACK(19, 0, 2*2) , SB_PACK( 0, 59, 0*0) } },
	{ { SB_PACK(10, 0, 2*2) , SB_PACK( 0, 29, 1*1) , SB_PACK(20, 0, 1*1) , SB_PACK( 7, 46, 0*0) } },
	{ { SB_PACK(10, 0, 1*1) , SB_PACK( 0, 30, 1*1) , SB_PACK(20, 0, 0*0) , SB_PACK( 0, 60, 0*0) } },
	{ { SB_PACK(10, 0, 0*0) , SB_PACK( 0, 30, 0*0) , SB_PACK(20, 0, 1*1) , SB_PACK( 0, 61, 0*0) } },
	{ { SB_PACK(10, 0, 1*1) , SB_PACK( 2, 27, 1*1) , SB_PACK(20, 0, 2*2) , SB_PACK( 0, 62, 0*0) } },
	{ { SB_PACK(10, 0, 2*2) , SB_PACK( 2, 27, 0*0) , SB_PACK(21, 0, 1*1) , SB_PACK( 8, 47, 0*0) } },
	{ { SB_PACK(10, 0, 3*3) , SB_PACK( 0, 31, 0*0) , SB_PACK(21, 0, 0*0) , SB_PACK( 0, 63, 0*0) } },
	{ { SB_PACK(10, 0, 4*4) , SB_PACK( 1, 30, 1*1) , SB_PACK(21, 0, 1*1) , SB_PACK( 1, 62, 0*0) } },
	{ { SB_PACK(11, 0, 3*3) , SB_PACK( 1, 30, 0*0) , SB_PACK(21, 0, 2*2) , SB_PACK( 1, 63, 0*0) } },
	{ { SB_PACK(11, 0, 2*2) , SB_PACK( 4, 24, 0*0) , SB_PACK(22, 0, 1*1) , SB_PACK(10, 46, 0*0) } },
	{ { SB_PACK(11, 0, 1*1) , SB_PACK( 1, 31, 1*1) , SB_PACK(22, 0, 0*0) , SB_PACK( 2, 62, 0*0) } },
	{ { SB_PACK(11, 0, 0*0) , SB_PACK( 1, 31, 0*0) , SB_PACK(22, 0, 1*1) , SB_PACK( 2, 63, 0*0) } },
	{ { SB_PACK(11, 0, 1*1) , SB_PACK( 1, 31, 1*1) , SB_PACK(22, 0, 2*2) , SB_PACK( 3, 62, 0*0) } },
	{ { SB_PACK(11, 0, 2*2) , SB_PACK( 2, 30, 1*1) , SB_PACK(23, 0, 1*1) , SB_PACK(11, 47, 0*0) } },
	{ { SB_PACK(11, 0, 3*3) , SB_PACK( 2, 30, 0*0) , SB_PACK(23, 0, 0*0) , SB_PACK( 3, 63, 0*0) } },
	{ { SB_PACK(11, 0, 4*4) , SB_PACK( 2, 31, 1*1) , SB_PACK(23, 0, 1*1) , SB_PACK( 4, 62, 0*0) } },
	{ { SB_PACK(12, 0, 4*4) , SB_PACK( 2, 31, 0*0) , SB_PACK(23, 0, 2*2) , SB_PACK( 4, 63, 0*0) } },
	{ { SB_PACK(12, 0, 3*3) , SB_PACK( 4, 27, 0*0) , SB_PACK(24, 0, 1*1) , SB_PACK(13, 46, 0*0) } },
	{ { SB_PACK(12, 0, 2*2) , SB_PACK( 3, 30, 1*1) , SB_PACK(24, 0, 0*0) , SB_PACK( 5, 62, 0*0) } },
	{ { SB_PACK(12, 0, 1*1) , SB_PACK( 3, 30, 0*0) , SB_PACK(24, 0, 1*1) , SB_PACK( 5, 63, 0*0) } },
	{ { SB_PACK(12, 0, 0*0) , SB_PACK( 4, 28, 0*0) , SB_PACK(24, 0, 2*2) , SB_PACK( 6, 62, 0*0) } },
	{ { SB_PACK(12, 0, 1*1) , SB_PACK( 3, 31, 1*1) , SB_PACK(25, 0, 1*1) , SB_PACK(14, 47, 0*0) } },
	{ { SB_PACK(12, 0, 2*2) , SB_PACK( 3, 31, 0*0) , SB_PACK(25, 0, 0*0) , SB_PACK( 6, 63, 0*0) } },
	{ { SB_PACK(12, 0, 3*3) , SB_PACK( 3, 31, 1*1) , SB_PACK(25, 0, 1*1) , SB_PACK( 7, 62, 0*0) } },
	{ { SB_PACK(12, 0, 4*4) , SB_PACK( 4, 30, 1*1) , SB_PACK(25, 0, 2*2) , SB_PACK( 7, 63, 0*0) } },
	{ { SB_PACK(13, 0, 3*3) , SB_PACK( 4, 30, 0*0) , SB_PACK(26, 0, 1*1) , SB_PACK(16, 45, 0*0) } },
	{ { SB_PACK(13, 0, 2*2) , SB_PACK( 6, 27, 1*1) , SB_PACK(26, 0, 0*0) , SB_PACK( 8, 62, 0*0) } },
	{ { SB_PACK(13, 0, 1*1) , SB_PACK( 6, 27, 0*0) , SB_PACK(26, 0, 1*1) , SB_PACK( 8, 63, 0*0) } },
	{ { SB_PACK(13, 0, 0*0) , SB_PACK( 4, 31, 0*0) , SB_PACK(26, 0, 2*2) , SB_PACK( 9, 62, 0*0) } },
	{ { SB_PACK(13, 0, 1*1) , SB_PACK( 5, 30, 1*1) , SB_PACK(27, 0, 1*1) , SB_PACK(16, 48, 0*0) } },
	{ { SB_PACK(13, 0, 2*2) , SB_PACK( 5, 30, 0*0) , SB_PACK(27, 0, 0*0) , SB_PACK( 9, 63, 0*0) } },
	{ { SB_PACK(13, 0, 3*3) , SB_PACK( 8, 24, 0*0) , SB_PACK(27, 0, 1*1) , SB_PACK(10, 62, 0*0) } },
	{ { SB_PACK(13, 0, 4*4) , SB_PACK( 5, 31, 1*1) , SB_PACK(27, 0, 2*2) , SB_PACK(10, 63, 0*0) } },
	{ { SB_PACK(14, 0, 3*3) , SB_PACK( 5, 31, 0*0) , SB_PACK(28, 0, 1*1) , SB_PACK(16, 51, 0*0) } },
	{ { SB_PACK(14, 0, 2*2) , SB_PACK( 5, 31, 1*1) , SB_PACK(28, 0, 0*0) , SB_PACK(11, 62, 0*0) } },
	{ { SB_PACK(14, 0, 1*1) , SB_PACK( 6, 30, 1*1) , SB_PACK(28, 0, 1*1) , SB_PACK(11, 63, 0*0) } },
	{ { SB_PACK(14, 0, 0*0) , SB_PACK( 6, 30, 0*0) , SB_PACK(28, 0, 2*2) , SB_PACK(12, 62, 0*0) } },
	{ { SB_PACK(14, 0, 1*1) , SB_PACK( 6, 31, 1*1) , SB_PACK(29, 0, 1*1) , SB_PACK(16, 54, 0*0) } },
	{ { SB_PACK(14, 0, 2*2) , SB_PACK( 6, 31, 0*0) , SB_PACK(29, 0, 0*0) , SB_PACK(12, 63, 0*0) } },
	{ { SB_PACK(14, 0, 3*3) , SB_PACK( 8, 27, 0*0) , SB_PACK(29, 0, 1*1) , SB_PACK(13, 62, 0*0) } },
	{ { SB_PACK(14, 0, 4*4) , SB_PACK( 7, 30, 1*1) , SB_PACK(29, 0, 2*2) , SB_PACK(13, 63, 0*0) } },
	{ { SB_PACK(15, 0, 3*3) , SB_PACK( 7, 30, 0*0) , SB_PACK(30, 0, 1*1) , SB_PACK(16, 57, 0*0) } },
	{ { SB_PACK(15, 0, 2*2) , SB_PACK( 8, 28, 0*0) , SB_PACK(30, 0, 0*0) , SB_PACK(14, 62, 0*0) } },
	{ { SB_PACK(15, 0, 1*1) , SB_PACK( 7, 31, 1*1) , SB_PACK(30, 0, 1*1) , SB_PACK(14, 63, 0*0) } },
	{ { SB_PACK(15, 0, 0*0) , SB_PACK( 7, 31, 0*0) , SB_PACK(30, 0, 2*2) , SB_PACK(15, 62, 0*0) } },
	{ { SB_PACK(15, 0, 1*1) , SB_PACK( 7, 31, 1*1) , SB_PACK(31, 0, 1*1) , SB_PACK(16, 60, 0*0) } },
	{ { SB_PACK(15, 0, 2*2) , SB_PACK( 8, 30, 1*1) , SB_PACK(31, 0, 0*0) , SB_PACK(15, 63, 0*0) } },
	{ { SB_PACK(15, 0, 3*3) , SB_PACK( 8, 30, 0*0) , SB_PACK(31, 0, 1*1) , SB_PACK(24, 46, 0*0) } },
	{ { SB_PACK(15, 0, 4*4) , SB_PACK(10, 27, 1*1) , SB_PACK(31, 0, 2*2) , SB_PACK(16, 62, 0*0) } },
	{ { SB_PACK(16, 0, 4*4) , SB_PACK(10, 27, 0*0) , SB_PACK(32, 0, 2*2) , SB_PACK(16, 63, 0*0) } },
	{ { SB_PACK(16, 0, 3*3) , SB_PACK( 8, 31, 0*0) , SB_PACK(32, 0, 1*1) , SB_PACK(17, 62, 0*0) } },
	{ { SB_PACK(16, 0, 2*2) , SB_PACK( 9, 30, 1*1) , SB_PACK(32, 0, 0*0) , SB_PACK(25, 47, 0*0) } },
	{ { SB_PACK(16, 0, 1*1) , SB_PACK( 9, 30, 0*0) , SB_PACK(32, 0, 1*1) , SB_PACK(17, 63, 0*0) } },
	{ { SB_PACK(16, 0, 0*0) , SB_PACK(12, 24, 0*0) , SB_PACK(32, 0, 2*2) , SB_PACK(18, 62, 0*0) } },
	{ { SB_PACK(16, 0, 1*1) , SB_PACK( 9, 31, 1*1) , SB_PACK(33, 0, 1*1) , SB_PACK(18, 63, 0*0) } },
	{ { SB_PACK(16, 0, 2*2) , SB_PACK( 9, 31, 0*0) , SB_PACK(33, 0, 0*0) , SB_PACK(27, 46, 0*0) } },
	{ { SB_PACK(16, 0, 3*3) , SB_PACK( 9, 31, 1*1) , SB_PACK(33, 0, 1*1) , SB_PACK(19, 62, 0*0) } },
	{ { SB_PACK(16, 0, 4*4) , SB_PACK(10, 30, 1*1) , SB_PACK(33, 0, 2*2) , SB_PACK(19, 63, 0*0) } },
	{ { SB_PACK(17, 0, 3*3) , SB_PACK(10, 30, 0*0) , SB_PACK(34, 0, 1*1) , SB_PACK(20, 62, 0*0) } },
	{ { SB_PACK(17, 0, 2*2) , SB_PACK(10, 31, 1*1) , SB_PACK(34, 0, 0*0) , SB_PACK(28, 47, 0*0) } },
	{ { SB_PACK(17, 0, 1*1) , SB_PACK(10, 31, 0*0) , SB_PACK(34, 0, 1*1) , SB_PACK(20, 63, 0*0) } },
	{ { SB_PACK(17, 0, 0*0) , SB_PACK(12, 27, 0*0) , SB_PACK(34, 0, 2*2) , SB_PACK(21, 62, 0*0) } },
	{ { SB_PACK(17, 0, 1*1) , SB_PACK(11, 30, 1*1) , SB_PACK(35, 0, 1*1) , SB_PACK(21, 63, 0*0) } },
	{ { SB_PACK(17, 0, 2*2) , SB_PACK(11, 30, 0*0) , SB_PACK(35, 0, 0*0) , SB_PACK(30, 46, 0*0) } },
	{ { SB_PACK(17, 0, 3*3) , SB_PACK(12, 28, 0*0) , SB_PACK(35, 0, 1*1) , SB_PACK(22, 62, 0*0) } },
	{ { SB_PACK(17, 0, 4*4) , SB_PACK(11, 31, 1*1) , SB_PACK(35, 0, 2*2) , SB_PACK(22, 63, 0*0) } },
	{ { SB_PACK(18, 0, 3*3) , SB_PACK(11, 31, 0*0) , SB_PACK(36, 0, 1*1) , SB_PACK(23, 62, 0*0) } },
	{ { SB_PACK(18, 0, 2*2) , SB_PACK(11, 31, 1*1) , SB_PACK(36, 0, 0*0) , SB_PACK(31, 47, 0*0) } },
	{ { SB_PACK(18, 0, 1*1) , SB_PACK(12, 30, 1*1) , SB_PACK(36, 0, 1*1) , SB_PACK(23, 63, 0*0) } },
	{ { SB_PACK(18, 0, 0*0) , SB_PACK(12, 30, 0*0) , SB_PACK(36, 0, 2*2) , SB_PACK(24, 62, 0*0) } },
	{ { SB_PACK(18, 0, 1*1) , SB_PACK(14, 27, 1*1) , SB_PACK(37, 0, 1*1) , SB_PACK(24, 63, 0*0) } },
	{ { SB_PACK(18, 0, 2*2) , SB_PACK(14, 27, 0*0) , SB_PACK(37, 0, 0*0) , SB_PACK(32, 47, 0*0) } },
	{ { SB_PACK(18, 0, 3*3) , SB_PACK(12, 31, 0*0) , SB_PACK(37, 0, 1*1) , SB_PACK(25, 62, 0*0) } },
	{ { SB_PACK(18, 0, 4*4) , SB_PACK(13, 30, 1*1) , SB_PACK(37, 0, 2*2) , SB_PACK(25, 63, 0*0) } },
	{ { SB_PACK(19, 0, 3*3) , SB_PACK(13, 30, 0*0) , SB_PACK(38, 0, 1*1) , SB_PACK(26, 62, 0*0) } },
	{ { SB_PACK(19, 0, 2*2) , SB_PACK(16, 24, 0*0) , SB_PACK(38, 0, 0*0) , SB_PACK(32, 50, 0*0) } },
	{ { SB_PACK(19, 0, 1*1) , SB_PACK(13, 31, 1*1) , SB_PACK(38, 0, 1*1) , SB_PACK(26, 63, 0*0) } },
	{ { SB_PACK(19, 0, 0*0) , SB_PACK(13, 31, 0*0) , SB_PACK(38, 0, 2*2) , SB_PACK(27, 62, 0*0) } },
	{ { SB_PACK(19, 0, 1*1) , SB_PACK(13, 31, 1*1) , SB_PACK(39, 0, 1*1) , SB_PACK(27, 63, 0*0) } },
	{ { SB_PACK(19, 0, 2*2) , SB_PACK(14, 30, 1*1) , SB_PACK(39, 0, 0*0) , SB_PACK(32, 53, 0*0) } },
	{ { SB_PACK(19, 0, 3*3) , SB_PACK(14, 30, 0*0) , SB_PACK(39, 0, 1*1) , SB_PACK(28, 62, 0*0) } },
	{ { SB_PACK(19, 0, 4*4) , SB_PACK(14, 31, 1*1) , SB_PACK(39, 0, 2*2) , SB_PACK(28, 63, 0*0) } },
	{ { SB_PACK(20, 0, 4*4) , SB_PACK(14, 31, 0*0) , SB_PACK(40, 0, 1*1) , SB_PACK(29, 62, 0*0) } },
	{ { SB_PACK(20, 0, 3*3) , SB_PACK(16, 27, 0*0) , SB_PACK(40, 0, 0*0) , SB_PACK(32, 56, 0*0) } },
	{ { SB_PACK(20, 0, 2*2) , SB_PACK(15, 30, 1*1) , SB_PACK(40, 0, 1*1) , SB_PACK(29, 63, 0*0) } },
	{ { SB_PACK(20, 0, 1*1) , SB_PACK(15, 30, 0*0) , SB_PACK(40, 0, 2*2) , SB_PACK(30, 62, 0*0) } },
	{ { SB_PACK(20, 0, 0*0) , SB_PACK(16, 28, 0*0) , SB_PACK(41, 0, 1*1) , SB_PACK(30, 63, 0*0) } },
	{ { SB_PACK(20, 0, 1*1) , SB_PACK(15, 31, 1*1) , SB_PACK(41, 0, 0*0) , SB_PACK(32, 59, 0*0) } },
	{ { SB_PACK(20, 0, 2*2) , SB_PACK(15, 31, 0*0) , SB_PACK(41, 0, 1*1) , SB_PACK(31, 62, 0*0) } },
	{ { SB_PACK(20, 0, 3*3) , SB_PACK(15, 31, 1*1) , SB_PACK(41, 0, 2*2) , SB_PACK(31, 63, 0*0) } },
	{ { SB_PACK(20, 0, 4*4) , SB_PACK(16, 30, 1*1) , SB_PACK(42, 0, 1*1) , SB_PACK(32, 61, 0*0) } },
	{ { SB_PACK(21, 0, 3*3) , SB_PACK(16, 30, 0*0) , SB_PACK(42, 0, 0*0) , SB_PACK(32, 62, 0*0) } },
	{ { SB_PACK(21, 0, 2*2) , SB_PACK(18, 27, 1*1) , SB_PACK(42, 0, 1*1) , SB_PACK(32, 63, 0*0) } },
	{ { SB_PACK(21, 0, 1*1) , SB_PACK(18, 27, 0*0) , SB_PACK(42, 0, 2*2) , SB_PACK(41, 46, 0*0) } },
	{ { SB_PACK(21, 0, 0*0) , SB_PACK(16, 31, 0*0) , SB_PACK(43, 0, 1*1) , SB_PACK(33, 62, 0*0) } },
	{ { SB_PACK(21, 0, 1*1) , SB_PACK(17, 30, 1*1) , SB_PACK(43, 0, 0*0) , SB_PACK(33, 63, 0*0) } },
	{ { SB_PACK(21, 0, 2*2) , SB_PACK(17, 30, 0*0) , SB_PACK(43, 0, 1*1) , SB_PACK(34, 62, 0*0) } },
	{ { SB_PACK(21, 0, 3*3) , SB_PACK(20, 24, 0*0) , SB_PACK(43, 0, 2*2) , SB_PACK(42, 47, 0*0) } },
	{ { SB_PACK(21, 0, 4*4) , SB_PACK(17, 31, 1*1) , SB_PACK(44, 0, 1*1) , SB_PACK(34, 63, 0*0) } },
	{ { SB_PACK(22, 0, 3*3) , SB_PACK(17, 31, 0*0) , SB_PACK(44, 0, 0*0) , SB_PACK(35, 62, 0*0) } },
	{ { SB_PACK(22, 0, 2*2) , SB_PACK(17, 31, 1*1) , SB_PACK(44, 0, 1*1) , SB_PACK(35, 63, 0*0) } },
	{ { SB_PACK(22, 0, 1*1) , SB_PACK(18, 30, 1*1) , SB_PACK(44, 0, 2*2) , SB_PACK(44, 46, 0*0) } },
	{ { SB_PACK(22, 0, 0*0) , SB_PACK(18, 30, 0*0) , SB_PACK(45, 0, 1*1) , SB_PACK(36, 62, 0*0) } },
	{ { SB_PACK(22, 0, 1*1) , SB_PACK(18, 31, 1*1) , SB_PACK(45, 0, 0*0) , SB_PACK(36, 63, 0*0) } },
	{ { SB_PACK(22, 0, 2*2) , SB_PACK(18, 31, 0*0) , SB_PACK(45, 0, 1*1) , SB_PACK(37, 62, 0*0) } },
	{ { SB_PACK(22, 0, 3*3) , SB_PACK(20, 27, 0*0) , SB_PACK(45, 0, 2*2) , SB_PACK(45, 47, 0*0) } },
	{ { SB_PACK(22, 0, 4*4) , SB_PACK(19, 30, 1*1) , SB_PACK(46, 0, 1*1) , SB_PACK(37, 63, 0*0) } },
	{ { SB_PACK(23, 0, 3*3) , SB_PACK(19, 30, 0*0) , SB_PACK(46, 0, 0*0) , SB_PACK(38, 62, 0*0) } },
	{ { SB_PACK(23, 0, 2*2) , SB_PACK(20, 28, 0*0) , SB_PACK(46, 0, 1*1) , SB_PACK(38, 63, 0*0) } },
	{ { SB_PACK(23, 0, 1*1) , SB_PACK(19, 31, 1*1) , SB_PACK(46, 0, 2*2) , SB_PACK(47, 46, 0*0) } },
	{ { SB_PACK(23, 0, 0*0) , SB_PACK(19, 31, 0*0) , SB_PACK(47, 0, 1*1) , SB_PACK(39, 62, 0*0) } },
	{ { SB_PACK(23, 0, 1*1) , SB_PACK(19, 31, 1*1) , SB_PACK(47, 0, 0*0) , SB_PACK(39, 63, 0*0) } },
	{ { SB_PACK(23, 0, 2*2) , SB_PACK(20, 30, 1*1) , SB_PACK(47, 0, 1*1) , SB_PACK(40, 62, 0*0) } },
	{ { SB_PACK(23, 0, 3*3) , SB_PACK(20, 30, 0*0) , SB_PACK(47, 0, 2*2) , SB_PACK(48, 46, 0*0) } },
	{ { SB_PACK(23, 0, 4*4) , SB_PACK(22, 27, 1*1) , SB_PACK(48, 0, 2*2) , SB_PACK(40, 63, 0*0) } },
	{ { SB_PACK(24, 0, 4*4) , SB_PACK(22, 27, 0*0) , SB_PACK(48, 0, 1*1) , SB_PACK(41, 62, 0*0) } },
	{ { SB_PACK(24, 0, 3*3) , SB_PACK(20, 31, 0*0) , SB_PACK(48, 0, 0*0) , SB_PACK(41, 63, 0*0) } },
	{ { SB_PACK(24, 0, 2*2) , SB_PACK(21, 30, 1*1) , SB_PACK(48, 0, 1*1) , SB_PACK(48, 49, 0*0) } },
	{ { SB_PACK(24, 0, 1*1) , SB_PACK(21, 30, 0*0) , SB_PACK(48, 0, 2*2) , SB_PACK(42, 62, 0*0) } },
	{ { SB_PACK(24, 0, 0*0) , SB_PACK(24, 24, 0*0) , SB_PACK(49, 0, 1*1) , SB_PACK(42, 63, 0*0) } },
	{ { SB_PACK(24, 0, 1*1) , SB_PACK(21, 31, 1*1) , SB_PACK(49, 0, 0*0) , SB_PACK(43, 62, 0*0) } },
	{ { SB_PACK(24, 0, 2*2) , SB_PACK(21, 31, 0*0) , SB_PACK(49, 0, 1*1) , SB_PACK(48, 52, 0*0) } },
	{ { SB_PACK(24, 0, 3*3) , SB_PACK(21, 31, 1*1) , SB_PACK(49, 0, 2*2) , SB_PACK(43, 63, 0*0) } },
	{ { SB_PACK(24, 0, 4*4) , SB_PACK(22, 30, 1*1) , SB_PACK(50, 0, 1*1) , SB_PACK(44, 62, 0*0) } },
	{ { SB_PACK(25, 0, 3*3) , SB_PACK(22, 30, 0*0) , SB_PACK(50, 0, 0*0) , SB_PACK(44, 63, 0*0) } },
	{ { SB_PACK(25, 0, 2*2) , SB_PACK(22, 31, 1*1) , SB_PACK(50, 0, 1*1) , SB_PACK(48, 55, 0*0) } },
	{ { SB_PACK(25, 0, 1*1) , SB_PACK(22, 31, 0*0) , SB_PACK(50, 0, 2*2) , SB_PACK(45, 62, 0*0) } },
	{ { SB_PACK(25, 0, 0*0) , SB_PACK(24, 27, 0*0) , SB_PACK(51, 0, 1*1) , SB_PACK(45, 63, 0*0) } },
	{ { SB_PACK(25, 0, 1*1) , SB_PACK(23, 30, 1*1) , SB_PACK(51, 0, 0*0) , SB_PACK(46, 62, 0*0) } },
	{ { SB_PACK(25, 0, 2*2) , SB_PACK(23, 30, 0*0) , SB_PACK(51, 0, 1*1) , SB_PACK(48, 58, 0*0) } },
	{ { SB_PACK(25, 0, 3*3) , SB_PACK(24, 28, 0*0) , SB_PACK(51, 0, 2*2) , SB_PACK(46, 63, 0*0) } },
	{ { SB_PACK(25, 0, 4*4) , SB_PACK(23, 31, 1*1) , SB_PACK(52, 0, 1*1) , SB_PACK(47, 62, 0*0) } },
	{ { SB_PACK(26, 0, 3*3) , SB_PACK(23, 31, 0*0) , SB_PACK(52, 0, 0*0) , SB_PACK(47, 63, 0*0) } },
	{ { SB_PACK(26, 0, 2*2) , SB_PACK(23, 31, 1*1) , SB_PACK(52, 0, 1*1) , SB_PACK(48, 61, 0*0) } },
	{ { SB_PACK(26, 0, 1*1) , SB_PACK(24, 30, 1*1) , SB_PACK(52, 0, 2*2) , SB_PACK(48, 62, 0*0) } },
	{ { SB_PACK(26, 0, 0*0) , SB_PACK(24, 30, 0*0) , SB_PACK(53, 0, 1*1) , SB_PACK(56, 47, 0*0) } },
	{ { SB_PACK(26, 0, 1*1) , SB_PACK(26, 27, 1*1) , SB_PACK(53, 0, 0*0) , SB_PACK(48, 63, 0*0) } },
	{ { SB_PACK(26, 0, 2*2) , SB_PACK(26, 27, 0*0) , SB_PACK(53, 0, 1*1) , SB_PACK(49, 62, 0*0) } },
	{ { SB_PACK(26, 0, 3*3) , SB_PACK(24, 31, 0*0) , SB_PACK(53, 0, 2*2) , SB_PACK(49, 63, 0*0) } },
	{ { SB_PACK(26, 0, 4*4) , SB_PACK(25, 30, 1*1) , SB_PACK(54, 0, 1*1) , SB_PACK(58, 46, 0*0) } },
	{ { SB_PACK(27, 0, 3*3) , SB_PACK(25, 30, 0*0) , SB_PACK(54, 0, 0*0) , SB_PACK(50, 62, 0*0) } },
	{ { SB_PACK(27, 0, 2*2) , SB_PACK(28, 24, 0*0) , SB_PACK(54, 0, 1*1) , SB_PACK(50, 63, 0*0) } },
	{ { SB_PACK(27, 0, 1*1) , SB_PACK(25, 31, 1*1) , SB_PACK(54, 0, 2*2) , SB_PACK(51, 62, 0*0) } },
	{ { SB_PACK(27, 0, 0*0) , SB_PACK(25, 31, 0*0) , SB_PACK(55, 0, 1*1) , SB_PACK(59, 47, 0*0) } },
	{ { SB_PACK(27, 0, 1*1) , SB_PACK(25, 31, 1*1) , SB_PACK(55, 0, 0*0) , SB_PACK(51, 63, 0*0) } },
	{ { SB_PACK(27, 0, 2*2) , SB_PACK(26, 30, 1*1) , SB_PACK(55, 0, 1*1) , SB_PACK(52, 62, 0*0) } },
	{ { SB_PACK(27, 0, 3*3) , SB_PACK(26, 30, 0*0) , SB_PACK(55, 0, 2*2) , SB_PACK(52, 63, 0*0) } },
	{ { SB_PACK(27, 0, 4*4) , SB_PACK(26, 31, 1*1) , SB_PACK(56, 0, 1*1) , SB_PACK(61, 46, 0*0) } },
	{ { SB_PACK(28, 0, 4*4) , SB_PACK(26, 31, 0*0) , SB_PACK(56, 0, 0*0) , SB_PACK(53, 62, 0*0) } },
	{ { SB_PACK(28, 0, 3*3) , SB_PACK(28, 27, 0*0) , SB_PACK(56, 0, 1*1) , SB_PACK(53, 63, 0*0) } },
	{ { SB_PACK(28, 0, 2*2) , SB_PACK(27, 30, 1*1) , SB_PACK(56, 0, 2*2) , SB_PACK(54, 62, 0*0) } },
	{ { SB_PACK(28, 0, 1*1) , SB_PACK(27, 30, 0*0) , SB_PACK(57, 0, 1*1) , SB_PACK(62, 47, 0*0) } },
	{ { SB_PACK(28, 0, 0*0) , SB_PACK(28, 28, 0*0) , SB_PACK(57, 0, 0*0) , SB_PACK(54, 63, 0*0) } },
	{ { SB_PACK(28, 0, 1*1) , SB_PACK(27, 31, 1*1) , SB_PACK(57, 0, 1*1) , SB_PACK(55, 62, 0*0) } },
	{ { SB_PACK(28, 0, 2*2) , SB_PACK(27, 31, 0*0) , SB_PACK(57, 0, 2*2) , SB_PACK(55, 63, 0*0) } },
	{ { SB_PACK(28, 0, 3*3) , SB_PACK(27, 31, 1*1) , SB_PACK(58, 0, 1*1) , SB_PACK(56, 62, 1*1) } },
	{ { SB_PACK(28, 0, 4*4) , SB_PACK(28, 30, 1*1) , SB_PACK(58, 0, 0*0) , SB_PACK(56, 62, 0*0) } },
	{ { SB_PACK(29, 0, 3*3) , SB_PACK(28, 30, 0*0) , SB_PACK(58, 0, 1*1) , SB_PACK(56, 63, 0*0) } },
	{ { SB_PACK(29, 0, 2*2) , SB_PACK(30, 27, 1*1) , SB_PACK(58, 0, 2*2) , SB_PACK(57, 62, 0*0) } },
	{ { SB_PACK(29, 0, 1*1) , SB_PACK(30, 27, 0*0) , SB_PACK(59, 0, 1*1) , SB_PACK(57, 63, 1*1) } },
	{ { SB_PACK(29, 0, 0*0) , SB_PACK(28, 31, 0*0) , SB_PACK(59, 0, 0*0) , SB_PACK(57, 63, 0*0) } },
	{ { SB_PACK(29, 0, 1*1) , SB_PACK(29, 30, 1*1) , SB_PACK(59, 0, 1*1) , SB_PACK(58, 62, 0*0) } },
	{ { SB_PACK(29, 0, 2*2) , SB_PACK(29, 30, 0*0) , SB_PACK(59, 0, 2*2) , SB_PACK(58, 63, 0*0) } },
	{ { SB_PACK(29, 0, 3*3) , SB_PACK(29, 30, 1*1) , SB_PACK(60, 0, 1*1) , SB_PACK(59, 62, 1*1) } },
	{ { SB_PACK(29, 0, 4*4) , SB_PACK(29, 31, 1*1) , SB_PACK(60, 0, 0*0) , SB_PACK(59, 62, 0*0) } },
	{ { SB_PACK(30, 0, 3*3) , SB_PACK(29, 31, 0*0) , SB_PACK(60, 0, 1*1) , SB_PACK(59, 63, 0*0) } },
	{ { SB_PACK(30, 0, 2*2) , SB_PACK(29, 31, 1*1) , SB_PACK(60, 0, 2*2) , SB_PACK(60, 62, 0*0) } },
	{ { SB_PACK(30, 0, 1*1) , SB_PACK(30, 30, 1*1) , SB_PACK(61, 0, 1*1) , SB_PACK(60, 63, 1*1) } },
	{ { SB_PACK(30, 0, 0*0) , SB_PACK(30, 30, 0*0) , SB_PACK(61, 0, 0*0) , SB_PACK(60, 63, 0*0) } },
	{ { SB_PACK(30, 0, 1*1) , SB_PACK(30, 31, 1*1) , SB_PACK(61, 0, 1*1) , SB_PACK(61, 62, 0*0) } },
	{ { SB_PACK(30, 0, 2*2) , SB_PACK(30, 31, 0*0) , SB_PACK(61, 0, 2*2) , SB_PACK(61, 63, 0*0) } },
	{ { SB_PACK(30, 0, 3*3) , SB_PACK(30, 31, 1*1) , SB_PACK(62, 0, 1*1) , SB_PACK(62, 62, 1*1) } },
	{ { SB_PACK(30, 0, 4*4) , SB_PACK(31, 30, 1*1) , SB_PACK(62, 0, 0*0) , SB_PACK(62, 62, 0*0) } },
	{ { SB_PACK(31, 0, 3*3) , SB_PACK(31, 30, 0*0) , SB_PACK(62, 0, 1*1) , SB_PACK(62, 63, 0*0) } },
	{ { SB_PACK(31, 0, 2*2) , SB_PACK(31, 30, 1*1) , SB_PACK(62, 0, 2*2) , SB_PACK(63, 62, 0*0) } },
	{ { SB_PACK(31, 0, 1*1) , SB_PACK(31, 31, 1*1) , SB_PACK(63, 0, 1*1) , SB_PACK(63, 63, 1*1) } },
	{ { SB_PACK(31, 0, 0*0) , SB_PACK(31, 31, 0*0) , SB_PACK(63, 0, 0*0) , SB_PACK(63, 63, 0*0) } }
}
};
#elif	!defined(USE_COMPUTE)
extern const ColourSingleLookup_CCR lookup_34_56_ccr[2][256];
#endif // LUT
