#
# Copyright (c) Contributors to the Open 3D Engine Project. For complete copyright and license terms please see the LICENSE at the root of this distribution.
# 
# SPDX-License-Identifier: Apache-2.0 OR MIT
#

# this file actually ingests the library and defines targets.


set(LIB_NAME "astc-encoder")
set(TARGET_WITH_NAMESPACE "3rdParty::${LIB_NAME}")

set(${LIB_NAME}_INCLUDE_DIR ${CMAKE_CURRENT_LIST_DIR}/${LIB_NAME}/include)
set(${LIB_NAME}_LIBRARY_DIR ${CMAKE_CURRENT_LIST_DIR}/${LIB_NAME}/bin)

if (${PAL_PLATFORM_NAME} STREQUAL "Windows")	
    set(${LIB_NAME}_LIBRARY_RELEASE ${${LIB_NAME}_LIBRARY_DIR}/Release/astcenc-sse4.1-static.lib)
    set(${LIB_NAME}_LIBRARY_DEBUG ${${LIB_NAME}_LIBRARY_DIR}/Debug/astcenc-sse4.1-static.lib)
elseif (${PAL_PLATFORM_NAME} STREQUAL "Linux")
    set(${LIB_NAME}_LIBRARY_RELEASE ${${LIB_NAME}_LIBRARY_DIR}/libastcenc-sse4.1-static.a)
    set(${LIB_NAME}_LIBRARY_DEBUG ${${LIB_NAME}_LIBRARY_RELEASE})
else()
    set(${LIB_NAME}_LIBRARY_RELEASE ${${LIB_NAME}_LIBRARY_DIR}/libastcenc-sse4.1-static.a)
    set(${LIB_NAME}_LIBRARY_DEBUG ${${LIB_NAME}_LIBRARY_RELEASE})
endif()

# declare the target so that others can 'depend on it'
add_library(${TARGET_WITH_NAMESPACE} STATIC IMPORTED GLOBAL)

# add include directory
ly_target_include_system_directories(TARGET ${TARGET_WITH_NAMESPACE} INTERFACE ${${LIB_NAME}_INCLUDE_DIR})

# add static library as "output" IMPORTED_LOCATION for the target
set_target_properties(${TARGET_WITH_NAMESPACE}
    PROPERTIES
        IMPORTED_LOCATION_DEBUG ${${LIB_NAME}_LIBRARY_DEBUG}
        IMPORTED_LOCATION ${${LIB_NAME}_LIBRARY_RELEASE}
)

set(${LIB_NAME}_FOUND True)
