#
# Copyright (c) Contributors to the Open 3D Engine Project.
# For complete copyright and license terms please see the LICENSE at the root of this distribution.
# 
# SPDX-License-Identifier: Apache-2.0 OR MIT
#
#

set(MY_NAME "SPIRVCross")
set(TARGET_WITH_NAMESPACE "3rdParty::${MY_NAME}")
if (TARGET ${TARGET_WITH_NAMESPACE})
    return()
endif()

set(output_subfolder "Builders/SPIRVCross")
set(${MY_NAME}_BINARY_DIR ${CMAKE_CURRENT_LIST_DIR}/${MY_NAME}/bin)
set(${MY_NAME}_RUNTIME_DEPENDENCIES ${${MY_NAME}_BINARY_DIR}/Release/spirv-cross)

add_library(${TARGET_WITH_NAMESPACE} INTERFACE IMPORTED GLOBAL)

ly_add_target_files(TARGETS ${TARGET_WITH_NAMESPACE} OUTPUT_SUBDIRECTORY ${output_subfolder} FILES ${${MY_NAME}_RUNTIME_DEPENDENCIES})

set(${MY_NAME}_FOUND True)
