#
# Copyright (c) Contributors to the Open 3D Engine Project.
# For complete copyright and license terms please see the LICENSE at the root of this distribution.
# 
# SPDX-License-Identifier: Apache-2.0 OR MIT
#
#

set(MY_NAME "mcpp")
set(TARGET_WITH_NAMESPACE "3rdParty::${MY_NAME}")
if (TARGET ${TARGET_WITH_NAMESPACE})
    return()
endif()

set(${MY_NAME}_INCLUDE_DIR ${CMAKE_CURRENT_LIST_DIR}/mcpp/include)
set(${MY_NAME}_LIBS_DIR ${CMAKE_CURRENT_LIST_DIR}/mcpp/lib)
set(${MY_NAME}_BINARY_DIR ${CMAKE_CURRENT_LIST_DIR}/mcpp/lib) #"lib" here is not a typo

set(${MY_NAME}_LIBRARY ${${MY_NAME}_LIBS_DIR}/libmcpp.a)
set(${MY_NAME}_RUNTIME_DEPENDENCIES ${${MY_NAME}_BINARY_DIR}/libmcpp.so)

add_library(${TARGET_WITH_NAMESPACE} INTERFACE IMPORTED GLOBAL)
ly_target_include_system_directories(TARGET ${TARGET_WITH_NAMESPACE} INTERFACE ${${MY_NAME}_INCLUDE_DIR})
target_link_libraries(${TARGET_WITH_NAMESPACE} 
                INTERFACE ${${MY_NAME}_LIBRARY})
ly_add_target_files(TARGETS ${TARGET_WITH_NAMESPACE} FILES ${${MY_NAME}_RUNTIME_DEPENDENCIES})

set(${MY_NAME}_FOUND True)
