#!/bin/bash

# Copyright (c) Contributors to the Open 3D Engine Project.
# For complete copyright and license terms please see the LICENSE at the root of this distribution.
#
# SPDX-License-Identifier: Apache-2.0 OR MIT
#

echo "This script will:"
echo "1. Create the .o3de folder in your home directory if it doesn't exist"
echo "2. Copy the offline 3rdParty and Python folders to that location"
echo
read -p "Press Enter to continue..."

# Create directory if it doesn't exist
if [ ! -d "$HOME/.o3de" ]; then
    mkdir "$HOME/.o3de"
fi

echo "Copying folders..."
# Using cp -r for recursive copy, will overwrite existing files
cp -r "3rdParty" "$HOME/.o3de/"
cp -r "Python" "$HOME/.o3de/"

echo
echo "Operation completed successfully!"
read -p "Press Enter to exit..."
