#
# All or portions of this file Copyright (c) Amazon.com, Inc. or its affiliates or
# its licensors.
#
# For complete copyright and license terms please see the LICENSE at the root of this
# distribution (the "License"). All use of this software is governed by the License,
# or, if provided, by the license below or the license accompanying this file. Do not
# remove or modify any license notices. This file is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#

# libsamplerate
set(TARGET_WITH_NAMESPACE 3rdParty::libsamplerate)
if (TARGET ${TARGET_WITH_NAMESPACE})
    return()
endif()

set(LIBSAMPLERATE_INCLUDE_DIR ${CMAKE_CURRENT_LIST_DIR}/libsamplerate/include)
set(LIBSAMPLERATE_LIBS_DIR ${CMAKE_CURRENT_LIST_DIR}/libsamplerate/lib)

set(LIBSAMPLERATE_COMPILE_DEFINITIONS )
set(LIBSAMPLERATE_LINK_OPTIONS )

set(LIBSAMPLERATE_LIBRARY ${LIBSAMPLERATE_LIBS_DIR}/${CMAKE_STATIC_LIBRARY_PREFIX}samplerate${CMAKE_STATIC_LIBRARY_SUFFIX})

add_library(${TARGET_WITH_NAMESPACE} INTERFACE IMPORTED GLOBAL)
ly_target_include_system_directories(TARGET ${TARGET_WITH_NAMESPACE} INTERFACE ${LIBSAMPLERATE_INCLUDE_DIR})
target_link_libraries(${TARGET_WITH_NAMESPACE} INTERFACE ${LIBSAMPLERATE_LIBRARY})
target_link_options(${TARGET_WITH_NAMESPACE} INTERFACE ${LIBSAMPLERATE_LINK_OPTIONS})
target_compile_definitions(${TARGET_WITH_NAMESPACE} INTERFACE ${LIBSAMPLERATE_COMPILE_DEFINITIONS})

set(LIBSAMPLERATE_FOUND True)
